"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCspIntegrationInfo = void 0;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/fleet-plugin/common");
var _use_kibana = require("../../common/hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCspIntegrationInfo = ({
  packagePolicyId,
  policyId
}) => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)(['cspBenchmarkRuleInfo', {
    packagePolicyId,
    policyId
  }], () => Promise.all([http.get(_common.packagePolicyRouteService.getInfoPath(packagePolicyId), {
    version: _common.API_VERSIONS.public.v1
  }).then(response => response.item), http.get(_common.agentPolicyRouteService.getInfoPath(policyId), {
    version: _common.API_VERSIONS.public.v1
  }).then(response => response.item)]));
};
exports.useCspIntegrationInfo = useCspIntegrationInfo;