"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesCounters = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _charts = require("@elastic/charts");
var _i18nReact = require("@kbn/i18n-react");
var _use_benchmark_dynamic_values = require("../../common/hooks/use_benchmark_dynamic_values");
var _compliance_score_chart = require("../compliance_dashboard/compliance_charts/compliance_score_chart");
var _test_subjects = require("./test_subjects");
var _no_data_illustration = _interopRequireDefault(require("../../assets/illustrations/no_data_illustration.svg"));
var _use_navigate_findings = require("../../common/hooks/use_navigate_findings");
var _constants = require("../../common/navigation/constants");
var _constants2 = require("../../../common/constants");
var _constants3 = require("../../common/constants");
var _use_csp_benchmark_integrations = require("../benchmarks/use_csp_benchmark_integrations");
var _csp_counter_card = require("../../components/csp_counter_card");
var _use_kibana = require("../../common/hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EvaluationPieChart = ({
  failed,
  passed
}) => {
  const {
    services: {
      charts
    }
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 30,
      width: 30
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [{
      partition: {
        outerSizeRatio: 0.75,
        emptySizeRatio: 0.7
      }
    }],
    baseTheme: charts.theme.useChartsBaseTheme()
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    id: 'evaluation-pie-chart',
    data: [{
      label: _i18n.i18n.translate('xpack.csp.rulesPage.evaluationPieChart.failedTitle', {
        defaultMessage: 'Failed'
      }),
      value: failed
    }, {
      label: _i18n.i18n.translate('xpack.csp.rulesPage.evaluationPieChart.passedTitle', {
        defaultMessage: 'Passed'
      }),
      value: passed
    }],
    valueGetter: "percent",
    valueAccessor: d => d.value,
    layout: _charts.PartitionLayout.sunburst,
    layers: [{
      // grouping the pie chart by data labels and coloring the group by the label value
      groupByRollup: d => d.label,
      shape: {
        fillColor: label => label.toLowerCase() === _constants2.RULE_PASSED.toLowerCase() ? _constants3.statusColors.passed : _constants3.statusColors.failed
      }
    }]
  }));
};
const RulesCounters = ({
  mutedRulesCount,
  setEnabledDisabledItemsFilter
}) => {
  var _getBenchmarks$data;
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    getBenchmarkDynamicValues
  } = (0, _use_benchmark_dynamic_values.useBenchmarkDynamicValues)();
  const rulesPageParams = (0, _reactRouterDom.useParams)();
  const getBenchmarks = (0, _use_csp_benchmark_integrations.useCspBenchmarkIntegrationsV2)();
  const navToFindings = (0, _use_navigate_findings.useNavigateFindings)();
  const benchmarkRulesStats = (_getBenchmarks$data = getBenchmarks.data) === null || _getBenchmarks$data === void 0 ? void 0 : _getBenchmarks$data.items.find(benchmark => benchmark.id === rulesPageParams.benchmarkId && benchmark.version === rulesPageParams.benchmarkVersion);
  if (!benchmarkRulesStats) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const benchmarkValues = getBenchmarkDynamicValues(benchmarkRulesStats.id);
  if (benchmarkRulesStats.score.totalFindings === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": _test_subjects.RULE_COUNTERS_TEST_SUBJ.RULE_COUNTERS_EMPTY_STATE,
      color: "plain",
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
        size: "fullWidth",
        src: _no_data_illustration.default,
        alt: _i18n.i18n.translate('xpack.csp.rulesPage.rulesCounterEmptyState.noDataIllustrationAlt', {
          defaultMessage: 'No data illustration'
        })
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.rulesPage.rulesCounterEmptyState.emptyStateTitle",
        defaultMessage: "Add {integrationResourceName} to get started",
        values: {
          integrationResourceName: `${benchmarkValues.integrationName}
                  ${benchmarkValues.resourceName}`
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.rulesPage.rulesCounterEmptyState.emptyStateDescription",
        defaultMessage: "Add your {resourceName} in {integrationType} to begin detecing misconfigurations",
        values: {
          resourceName: benchmarkValues.resourceName.toLowerCase(),
          integrationType: benchmarkValues.integrationType
        }
      })),
      actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        fill: true,
        href: benchmarkValues.integrationLink
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.rulesPage.rulesCounterEmptyState.emptyPrimapryButtonTitle",
        defaultMessage: "Add {integrationType} integration",
        values: {
          integrationType: benchmarkValues.integrationType
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        color: "primary",
        href: benchmarkValues.learnMoreLink,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.rulesPage.rulesCounterEmptyState.emptyLearnMoreButtonTitle",
        defaultMessage: "Learn more"
      }))],
      layout: "horizontal",
      paddingSize: "m"
    });
  }
  const counters = [{
    id: _test_subjects.RULE_COUNTERS_TEST_SUBJ.POSTURE_SCORE_COUNTER,
    description: _i18n.i18n.translate('xpack.csp.rulesCounters.postureScoreTitle', {
      defaultMessage: 'Posture Score'
    }),
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(EvaluationPieChart, {
      failed: benchmarkRulesStats.score.totalFailed,
      passed: benchmarkRulesStats.score.totalPassed
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, (0, _compliance_score_chart.getPostureScorePercentage)(benchmarkRulesStats.score.postureScore))),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": _test_subjects.RULE_COUNTERS_TEST_SUBJ.POSTURE_SCORE_BUTTON,
      iconType: "pivot",
      href: http.basePath.prepend(`/app/security${_constants.cloudPosturePages.dashboard.path}`)
    }, _i18n.i18n.translate('xpack.csp.rulesCounters.postureScoreButton', {
      defaultMessage: 'Dashboard'
    }))
  }, {
    id: _test_subjects.RULE_COUNTERS_TEST_SUBJ.INTEGRATIONS_EVALUATED_COUNTER,
    description: _i18n.i18n.translate('xpack.csp.rulesCounters.accountsEvaluatedTitle', {
      defaultMessage: '{resourceName} Evaluated',
      values: {
        resourceName: benchmarkValues.resourceName
      }
    }),
    title: benchmarkRulesStats.evaluation || 0,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": _test_subjects.RULE_COUNTERS_TEST_SUBJ.INTEGRATIONS_EVALUATED_BUTTON,
      iconType: "listAdd",
      href: benchmarkValues.integrationLink
    }, _i18n.i18n.translate('xpack.csp.rulesCounters.accountsEvaluatedButton', {
      defaultMessage: 'Add more {resourceName}',
      values: {
        resourceName: benchmarkValues.resourceName.toLowerCase()
      }
    }))
  }, {
    id: _test_subjects.RULE_COUNTERS_TEST_SUBJ.FAILED_FINDINGS_COUNTER,
    description: _i18n.i18n.translate('xpack.csp.rulesCounters.failedFindingsTitle', {
      defaultMessage: 'Failed Findings'
    }),
    title: benchmarkRulesStats.score.totalFailed,
    titleColor: benchmarkRulesStats.score.totalFailed > 0 ? _constants3.statusColors.failed : undefined,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": _test_subjects.RULE_COUNTERS_TEST_SUBJ.FAILED_FINDINGS_BUTTON,
      iconType: "pivot",
      onClick: () => navToFindings({
        'result.evaluation': _constants2.RULE_FAILED,
        'rule.benchmark.id': benchmarkRulesStats.id || '',
        'rule.benchmark.version': `v${benchmarkRulesStats.version}`
      })
    }, _i18n.i18n.translate('xpack.csp.rulesCounters.failedFindingsButton', {
      defaultMessage: 'View all failed findings'
    }))
  }, {
    id: _test_subjects.RULE_COUNTERS_TEST_SUBJ.DISABLED_RULES_COUNTER,
    description: _i18n.i18n.translate('xpack.csp.rulesCounters.disabledRulesCounterTitle', {
      defaultMessage: 'Disabled Rules'
    }),
    title: mutedRulesCount,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": _test_subjects.RULE_COUNTERS_TEST_SUBJ.DISABLED_RULES_BUTTON,
      iconType: "search",
      onClick: () => setEnabledDisabledItemsFilter('disabled')
    }, _i18n.i18n.translate('xpack.csp.rulesCounters.disabledRulesCounterButton', {
      defaultMessage: 'View all disabled rules'
    }))
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, counters.map(counter => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: counter.id
  }, /*#__PURE__*/_react.default.createElement(_csp_counter_card.CspCounterCard, counter))));
};
exports.RulesCounters = RulesCounters;