"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatestFindingsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var TEST_SUBJECTS = _interopRequireWildcard(require("../test_subjects"));
var _findings_distribution_bar = require("../layout/findings_distribution_bar");
var _error_callout = require("../layout/error_callout");
var _cloud_security_data_table = require("../../../components/cloud_security_data_table");
var _constants = require("./constants");
var _use_latest_findings_table = require("./use_latest_findings_table");
var _timestamp_table_cell = require("../../../components/timestamp_table_cell");
var _csp_evaluation_badge = require("../../../components/csp_evaluation_badge");
var _findings_flyout = require("../findings_flyout/findings_flyout");
var _create_detection_rule_from_benchmark = require("../utils/create_detection_rule_from_benchmark");
var _findings_table_field_labels = require("./findings_table_field_labels");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type Guard for checking if the given source is a CspFinding
 */
const isCspFinding = source => {
  var _source$result;
  return (source === null || source === void 0 ? void 0 : (_source$result = source.result) === null || _source$result === void 0 ? void 0 : _source$result.evaluation) !== undefined;
};
const getCspFinding = source => {
  return isCspFinding(source) && source;
};

/**
 * This Wrapper component renders the children if the given row is a CspFinding
 * it uses React's Render Props pattern
 */
const CspFindingRenderer = ({
  row,
  children
}) => {
  const finding = getCspFinding(row.raw._source);
  if (!finding) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return children({
    finding
  });
};

/**
 * Flyout component for the latest findings table
 */
const flyoutComponent = (row, onCloseFlyout) => {
  return /*#__PURE__*/_react.default.createElement(CspFindingRenderer, {
    row: row
  }, ({
    finding
  }) => /*#__PURE__*/_react.default.createElement(_findings_flyout.FindingsRuleFlyout, {
    findings: finding,
    onClose: onCloseFlyout
  }));
};
const title = _i18n.i18n.translate('xpack.csp.findings.latestFindings.tableRowTypeLabel', {
  defaultMessage: 'Findings'
});
const customCellRenderer = rows => ({
  'result.evaluation': ({
    rowIndex
  }) => /*#__PURE__*/_react.default.createElement(CspFindingRenderer, {
    row: rows[rowIndex]
  }, ({
    finding
  }) => /*#__PURE__*/_react.default.createElement(_csp_evaluation_badge.CspEvaluationBadge, {
    type: finding.result.evaluation
  })),
  '@timestamp': ({
    rowIndex
  }) => /*#__PURE__*/_react.default.createElement(CspFindingRenderer, {
    row: rows[rowIndex]
  }, ({
    finding
  }) => /*#__PURE__*/_react.default.createElement(_timestamp_table_cell.TimestampTableCell, {
    timestamp: finding['@timestamp']
  }))
});
const LatestFindingsTable = ({
  groupSelectorComponent,
  height,
  showDistributionBar = true,
  nonPersistedFilters
}) => {
  const {
    cloudPostureDataTable,
    rows,
    error,
    isFetching,
    isLoading,
    fetchNextPage,
    passed,
    failed,
    total,
    canShowDistributionBar,
    onDistributionBarClick
  } = (0, _use_latest_findings_table.useLatestFindingsTable)({
    getDefaultQuery: _constants.getDefaultQuery,
    nonPersistedFilters,
    showDistributionBar
  });
  const createMisconfigurationRuleFn = rowIndex => {
    const finding = getCspFinding(rows[rowIndex].raw._source);
    if (!finding) return;
    return async http => (0, _create_detection_rule_from_benchmark.createDetectionRuleFromBenchmarkRule)(http, finding.rule);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": TEST_SUBJECTS.LATEST_FINDINGS_CONTAINER
  }, error ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
    error: error
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canShowDistributionBar && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_findings_distribution_bar.FindingsDistributionBar, {
    distributionOnClick: onDistributionBarClick,
    passed: passed,
    failed: failed
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_cloud_security_data_table.CloudSecurityDataTable, {
    "data-test-subj": TEST_SUBJECTS.LATEST_FINDINGS_TABLE,
    isLoading: isFetching || isLoading,
    defaultColumns: _constants.defaultColumns,
    rows: rows,
    total: total,
    flyoutComponent: flyoutComponent,
    cloudPostureDataTable: cloudPostureDataTable,
    loadMore: fetchNextPage,
    title: title,
    customCellRenderer: customCellRenderer,
    groupSelectorComponent: groupSelectorComponent,
    height: height,
    createRuleFn: createMisconfigurationRuleFn,
    columnHeaders: _findings_table_field_labels.findingsTableFieldLabels
  })));
};
exports.LatestFindingsTable = LatestFindingsTable;