"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showCreateDetectionRuleSuccessToast = exports.showChangeBenchmarkRuleStatesSuccessToast = exports.TakeAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _test_subjects = require("./test_subjects");
var _use_kibana = require("../common/hooks/use_kibana");
var _constants = require("../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_PAGE_PATH = '/app/security/rules/id/';
const showCreateDetectionRuleSuccessToast = (cloudSecurityStartServices, http, ruleResponse) => {
  const {
    notifications,
    analytics,
    i18n,
    theme
  } = cloudSecurityStartServices;
  const startServices = {
    analytics,
    i18n,
    theme
  };
  return notifications.toasts.addSuccess({
    toastLifeTimeMs: 10000,
    color: 'success',
    iconType: '',
    'data-test-subj': 'csp:toast-success',
    title: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": "csp:toast-success-title"
    }, ruleResponse.name), ` `, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleCreatedToastTitle",
      defaultMessage: "detection rule was created."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleCreatedToast",
      defaultMessage: "Add rule actions to get notified when alerts are generated."
    }))), startServices),
    text: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "csp:toast-success-link",
      size: "s",
      href: http.basePath.prepend(RULE_PAGE_PATH + ruleResponse.id)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleCreatedToastViewRuleButton",
      defaultMessage: "View rule"
    }))))), startServices)
  });
};
exports.showCreateDetectionRuleSuccessToast = showCreateDetectionRuleSuccessToast;
const showChangeBenchmarkRuleStatesSuccessToast = (cloudSecurityStartServices, isBenchmarkRuleMuted, data) => {
  const {
    notifications,
    analytics,
    i18n,
    theme
  } = cloudSecurityStartServices;
  const startServices = {
    analytics,
    i18n,
    theme
  };
  return notifications.toasts.addSuccess({
    toastLifeTimeMs: 10000,
    color: 'success',
    iconType: '',
    'data-test-subj': 'csp:toast-success-rule-state-change',
    title: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": `csp:toast-success-rule-title`
    }, isBenchmarkRuleMuted ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleEnabledToastTitle",
      defaultMessage: "Rule Enabled"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleDisabledToastTitle",
      defaultMessage: "Rule Disabled"
    }))), startServices),
    text: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement("div", null, isBenchmarkRuleMuted ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleEnabledToastRulesCount",
      defaultMessage: "Successfully enabled {ruleCount, plural, one {# rule} other {# rules}} ",
      values: {
        ruleCount: data.numberOfRules
      }
    }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleDisabledToastRulesCount",
      defaultMessage: "Successfully disabled {ruleCount, plural, one {# rule} other {# rules}} ",
      values: {
        ruleCount: data.numberOfRules
      }
    }), !isBenchmarkRuleMuted && data.numberOfDetectionRules > 0 && /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleDisabledToastDetectionRulesCount",
      defaultMessage: " and {detectionRuleCount, plural, one {# detection rule} other {# detection rules}}",
      values: {
        detectionRuleCount: data.numberOfDetectionRules
      }
    })))), startServices)
  });
};

/*
 * This component is used to create a detection rule from Flyout.
 * It accepts a createRuleFn parameter which is used to create a rule in a generic way.
 */
exports.showChangeBenchmarkRuleStatesSuccessToast = showChangeBenchmarkRuleStatesSuccessToast;
const TakeAction = ({
  createRuleFn,
  enableBenchmarkRuleFn,
  disableBenchmarkRuleFn,
  isCreateDetectionRuleDisabled = false,
  isDataGridControlColumn: isDataTableAction = false
}) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const closePopover = () => {
    setPopoverOpen(false);
  };
  const smallContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'smallContextMenuPopover'
  });
  const button = !isDataTableAction ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    fill: true,
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setPopoverOpen(!isPopoverOpen)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.flyout.takeActionButton",
    defaultMessage: "Take action"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.csp.flyout.moreActionsButton', {
      defaultMessage: 'More actions'
    }),
    iconType: "boxesHorizontal",
    color: "primary",
    isLoading: isLoading,
    onClick: () => setPopoverOpen(!isPopoverOpen)
  });
  const actionsItems = [];
  if (createRuleFn) actionsItems.push( /*#__PURE__*/_react.default.createElement(CreateDetectionRule, {
    key: "createRule",
    createRuleFn: createRuleFn,
    setIsLoading: setIsLoading,
    closePopover: closePopover,
    queryClient: queryClient,
    isCreateDetectionRuleDisabled: isCreateDetectionRuleDisabled
  }));
  if (enableBenchmarkRuleFn) actionsItems.push( /*#__PURE__*/_react.default.createElement(EnableBenchmarkRule, {
    key: "enableBenchmarkRule",
    enableBenchmarkRuleFn: enableBenchmarkRuleFn,
    setIsLoading: setIsLoading,
    closePopover: closePopover
  }));
  if (disableBenchmarkRuleFn) actionsItems.push( /*#__PURE__*/_react.default.createElement(DisableBenchmarkRule, {
    key: "disableBenchmarkRule",
    disableBenchmarkRuleFn: disableBenchmarkRuleFn,
    setIsLoading: setIsLoading,
    closePopover: closePopover
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: smallContextMenuPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    "data-test-subj": _test_subjects.TAKE_ACTION_SUBJ
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: actionsItems
  }));
};
exports.TakeAction = TakeAction;
const CreateDetectionRule = ({
  createRuleFn,
  setIsLoading,
  closePopover,
  queryClient,
  isCreateDetectionRuleDisabled = false
}) => {
  const {
    http,
    ...startServices
  } = (0, _use_kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "createRule",
    disabled: isCreateDetectionRuleDisabled,
    onClick: async () => {
      closePopover();
      setIsLoading(true);
      const ruleResponse = await createRuleFn(http);
      setIsLoading(false);
      showCreateDetectionRuleSuccessToast(startServices, http, ruleResponse);
      // Triggering a refetch of rules and alerts to update the UI
      queryClient.invalidateQueries([_constants.DETECTION_ENGINE_RULES_KEY]);
      queryClient.invalidateQueries([_constants.DETECTION_ENGINE_ALERTS_KEY]);
    },
    "data-test-subj": _test_subjects.CREATE_RULE_ACTION_SUBJ
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Create a detection rule",
    id: "xpack.csp.createDetectionRuleButton"
  }));
};
const EnableBenchmarkRule = ({
  enableBenchmarkRuleFn,
  setIsLoading,
  closePopover
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "enableBenchmarkRule",
    onClick: async () => {
      closePopover();
      setIsLoading(true);
      await enableBenchmarkRuleFn();
      setIsLoading(false);
    },
    "data-test-subj": 'enable-benchmark-rule-take-action-button'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Enable Rule",
    id: "xpack.csp.enableBenchmarkRuleButton"
  }));
};
const DisableBenchmarkRule = ({
  disableBenchmarkRuleFn,
  setIsLoading,
  closePopover
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "disableBenchmarkRule",
    onClick: async () => {
      closePopover();
      setIsLoading(true);
      await disableBenchmarkRuleFn();
      setIsLoading(false);
    },
    "data-test-subj": 'disable-benchmark-rule-take-action-button'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Disable Rule",
    id: "xpack.csp.disableBenchmarkRuleButton"
  }));
};