"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubscriptionNotAllowed = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_license_management_locator_api = require("../common/api/use_license_management_locator_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SubscriptionNotAllowed = () => {
  const handleNavigateToLicenseManagement = (0, _use_license_management_locator_api.useLicenseManagementLocatorApi)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    color: "danger",
    alignment: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.subscriptionNotAllowed.promptTitle",
      defaultMessage: "Upgrade for subscription features"
    })),
    body: handleNavigateToLicenseManagement ? /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": 'has_locator'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.subscriptionNotAllowed.promptDescription",
      defaultMessage: "To use these cloud security features, you must {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: handleNavigateToLicenseManagement
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.subscriptionNotAllowed.promptLinkText",
          defaultMessage: "start a trial or upgrade your subscription"
        }))
      }
    })) : /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": 'no_locator'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.subscriptionNotAllowed.promptDescriptionNoLocator",
      defaultMessage: "Contact your administrator to change your license."
    }))
  }));
};
exports.SubscriptionNotAllowed = SubscriptionNotAllowed;