"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GcpCredentialsFormAgentless = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _compare = _interopRequireDefault(require("semver/functions/compare"));
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _i18nReact = require("@kbn/i18n-react");
var _get_template_url_package_info = require("../../../common/utils/get_template_url_package_info");
var _constants = require("../../../../common/constants");
var _gcp_credential_form = require("./gcp_credential_form");
var _utils = require("../utils");
var _aws_credentials_form = require("../aws_credentials_form/aws_credentials_form");
var _constants2 = require("../../../common/navigation/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GcpCredentialsFormAgentless = ({
  input,
  newPolicy,
  updatePolicy,
  packageInfo,
  disabled
}) => {
  var _input$streams, _input$streams$, _input$streams$$vars, _input$streams$$vars$, _getTemplateUrlFromPa;
  const accountType = (_input$streams = input.streams) === null || _input$streams === void 0 ? void 0 : (_input$streams$ = _input$streams[0]) === null || _input$streams$ === void 0 ? void 0 : (_input$streams$$vars = _input$streams$.vars) === null || _input$streams$$vars === void 0 ? void 0 : (_input$streams$$vars$ = _input$streams$$vars['gcp.account_type']) === null || _input$streams$$vars$ === void 0 ? void 0 : _input$streams$$vars$.value;
  const isOrganization = accountType === _constants.ORGANIZATION_ACCOUNT;
  const organizationFields = ['gcp.organization_id', 'gcp.credentials.json'];
  const singleAccountFields = ['gcp.project_id', 'gcp.credentials.json'];
  const isValidSemantic = (0, _valid.default)(packageInfo.version);
  const showCloudCredentialsButton = isValidSemantic ? (0, _compare.default)(packageInfo.version, _constants.CLOUD_CREDENTIALS_PACKAGE_VERSION) >= 0 : false;

  /*
    For Agentless only JSON credentials type is supported.
    Also in case of organisation setup, project_id is not required in contrast to Agent-based.
   */
  const fields = (0, _gcp_credential_form.getInputVarsFields)(input, _gcp_credential_form.gcpField.fields).filter(field => {
    if (isOrganization) {
      return organizationFields.includes(field.id);
    } else {
      return singleAccountFields.includes(field.id);
    }
  });
  const cloudShellUrl = (_getTemplateUrlFromPa = (0, _get_template_url_package_info.getTemplateUrlFromPackageInfo)(packageInfo, input.policy_template, _get_template_url_package_info.SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS.CLOUD_SHELL_URL)) === null || _getTemplateUrlFromPa === void 0 ? void 0 : _getTemplateUrlFromPa.replace(_constants.TEMPLATE_URL_ACCOUNT_TYPE_ENV_VAR, accountType);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !showCloudCredentialsButton && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.gcpCloudCredentials.cloudFormationSupportedMessage",
    defaultMessage: "Launch Cloud Shell for automated credentials not supported in current integration version. Please upgrade to the latest version to enable Launch Cloud Shell for automated credentials."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), showCloudCredentialsButton && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "launchGoogleCloudShellAgentlessButton",
    target: "_blank",
    iconSide: "left",
    iconType: "launch",
    href: cloudShellUrl
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.agentlessForm.googleCloudShell.cloudCredentials.button",
    defaultMessage: "Launch Google Cloud Shell"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_gcp_credential_form.GcpInputVarFields, {
    disabled: disabled,
    fields: fields,
    onChange: (key, value) => updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
      [key]: {
        value
      }
    })),
    isOrganization: isOrganization
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_aws_credentials_form.ReadDocumentation, {
    url: _constants2.cspIntegrationDocsNavigation.cspm.getStartedPath
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.GcpCredentialsFormAgentless = GcpCredentialsFormAgentless;