"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloudSecurityGrouping = void 0;
var _react = require("react");
var _grouping = require("@kbn/grouping");
var uuid = _interopRequireWildcard(require("uuid"));
var _use_url_query = require("../../common/hooks/use_url_query");
var _use_cloud_posture_data_table = require("../../common/hooks/use_cloud_posture_data_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE_SIZE = 10;
const DEFAULT_MAX_GROUPING_LEVELS = 3;

/*
 Utility hook to handle the grouping logic of the cloud security components
*/
const useCloudSecurityGrouping = ({
  dataView,
  groupingTitle,
  defaultGroupingOptions,
  getDefaultQuery,
  unit,
  groupPanelRenderer,
  groupStatsRenderer,
  groupingLevel,
  groupingLocalStorageKey,
  maxGroupingLevels = DEFAULT_MAX_GROUPING_LEVELS,
  groupsUnit
}) => {
  const getPersistedDefaultQuery = (0, _use_cloud_posture_data_table.usePersistedQuery)(getDefaultQuery);
  const {
    urlQuery,
    setUrlQuery
  } = (0, _use_url_query.useUrlQuery)(getPersistedDefaultQuery);
  const [activePageIndex, setActivePageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(DEFAULT_PAGE_SIZE);
  const {
    query,
    error
  } = (0, _use_cloud_posture_data_table.useBaseEsQuery)({
    filters: urlQuery.filters,
    query: urlQuery.query
  });
  const grouping = (0, _grouping.useGrouping)({
    componentProps: {
      unit,
      groupPanelRenderer,
      groupStatsRenderer,
      groupsUnit
    },
    defaultGroupingOptions,
    fields: dataView.fields,
    groupingId: groupingLocalStorageKey,
    maxGroupingLevels,
    title: groupingTitle,
    onGroupChange: ({
      groupByFields
    }) => {
      setActivePageIndex(0);
      setUrlQuery({
        groupBy: groupByFields
      });
    }
  });
  const selectedGroup = groupingLevel ? grouping.selectedGroups[groupingLevel] : grouping.selectedGroups[0];
  /**
   * Reset the active page when the filters or query change
   * This is needed because the active page is not automatically reset when the filters or query change
   */
  (0, _react.useEffect)(() => {
    setActivePageIndex(0);
  }, [urlQuery.filters, urlQuery.query]);

  /**
   * Set the selected groups from the URL query on the initial render
   */
  (0, _react.useEffect)(() => {
    if (urlQuery.groupBy) {
      grouping.setSelectedGroups(urlQuery.groupBy);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // This is recommended by the grouping component to cover an edge case
  // where the selectedGroup has multiple values
  const uniqueValue = (0, _react.useMemo)(() => `${selectedGroup}-${uuid.v4()}`, [selectedGroup]);
  const isNoneSelected = (0, _grouping.isNoneGroup)(grouping.selectedGroups);
  const onChangeGroupsItemsPerPage = size => {
    setActivePageIndex(0);
    setPageSize(size);
  };
  const onResetFilters = (0, _react.useCallback)(() => {
    setUrlQuery({
      filters: [],
      query: {
        query: '',
        language: 'kuery'
      }
    });
  }, [setUrlQuery]);
  const onChangeGroupsPage = index => setActivePageIndex(index);
  return {
    activePageIndex,
    setActivePageIndex,
    grouping,
    pageSize,
    query,
    error,
    selectedGroup,
    urlQuery,
    setUrlQuery,
    uniqueValue,
    isNoneSelected,
    onChangeGroupsItemsPerPage,
    onChangeGroupsPage,
    onResetFilters,
    filters: urlQuery.filters
  };
};
exports.useCloudSecurityGrouping = useCloudSecurityGrouping;