"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudSecurityGroupingLoading = exports.CloudSecurityGrouping = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _test_subjects = require("../test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component is used to render the loading state of the CloudSecurityGrouping component
 * It's used to avoid the flickering of the table when the data is loading
 */
const CloudSecurityGroupingLoading = ({
  grouping,
  pageSize
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_subjects.CSP_GROUPING_LOADING
  }, grouping.getGrouping({
    activePage: 0,
    data: {
      groupsCount: {
        value: 1
      },
      unitsCount: {
        value: 1
      }
    },
    groupingLevel: 0,
    inspectButton: undefined,
    isLoading: true,
    itemsPerPage: pageSize,
    renderChildComponent: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    onGroupClose: () => {},
    selectedGroup: '',
    takeActionItems: () => []
  }));
};
exports.CloudSecurityGroupingLoading = CloudSecurityGroupingLoading;
const CloudSecurityGrouping = ({
  data,
  renderChildComponent,
  grouping,
  activePageIndex,
  isFetching,
  pageSize,
  onChangeGroupsItemsPerPage,
  onChangeGroupsPage,
  selectedGroup,
  groupingLevel = 0,
  groupSelectorComponent
}) => {
  if (!data || isFetching) {
    return /*#__PURE__*/_react.default.createElement(CloudSecurityGroupingLoading, {
      grouping: grouping,
      pageSize: pageSize
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_subjects.CSP_GROUPING,
    css: (0, _react2.css)`
        position: relative;
        && [data-test-subj='group-stats'] > .euiFlexItem:last-child {
          display: none;
        }
        && [data-test-subj='group-stats'] > .euiFlexItem:not(:first-child) > span {
          border-right: none;
          margin-right: 0;
        }
      `
  }, groupSelectorComponent && /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
            position: absolute;
            right: 0;
            top: 16px;
          `
  }, groupSelectorComponent), /*#__PURE__*/_react.default.createElement("div", {
    css: groupSelectorComponent ? (0, _react2.css)`
                && [data-test-subj='alerts-table-group-selector'] {
                  display: none;
                }
              ` : undefined
  }, grouping.getGrouping({
    activePage: activePageIndex,
    data,
    groupingLevel,
    selectedGroup,
    inspectButton: undefined,
    isLoading: isFetching,
    itemsPerPage: pageSize,
    onChangeGroupsItemsPerPage,
    onChangeGroupsPage,
    renderChildComponent,
    onGroupClose: () => {},
    takeActionItems: () => []
  })));
};
exports.CloudSecurityGrouping = CloudSecurityGrouping;