"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLimitProperties = exports.getLimitProperties = void 0;
var _react = require("react");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLimitProperties = (totalItems, maxItems, pageSize, pageIndex) => {
  const limitItems = totalItems > maxItems;
  const limitedTotalItemCount = limitItems ? maxItems : totalItems;
  const lastLimitedPage = Math.ceil(limitedTotalItemCount / pageSize);
  const isLastPage = lastLimitedPage === pageIndex + 1;
  const isLastLimitedPage = limitItems && isLastPage;
  return {
    isLastLimitedPage,
    limitedTotalItemCount
  };
};
exports.getLimitProperties = getLimitProperties;
const useLimitProperties = ({
  total,
  pageIndex,
  pageSize
}) => (0, _react.useMemo)(() => getLimitProperties(total || 0, _constants.MAX_FINDINGS_TO_LOAD, pageSize, pageIndex), [total, pageIndex, pageSize]);
exports.useLimitProperties = useLimitProperties;