"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSubscriptionStatus = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _setup_context = require("../../application/setup_context");
var _subscription = require("../../../common/utils/subscription");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUBSCRIPTION_QUERY_KEY = 'csp_subscription_query_key';
const useSubscriptionStatus = () => {
  const {
    licensing
  } = (0, _use_kibana.useKibana)().services;
  const {
    isCloudEnabled
  } = (0, _react.useContext)(_setup_context.SetupContext);
  return (0, _reactQuery.useQuery)([SUBSCRIPTION_QUERY_KEY], async () => {
    const license = await licensing.refresh();
    return (0, _subscription.isSubscriptionAllowed)(isCloudEnabled, license);
  });
};
exports.useSubscriptionStatus = useSubscriptionStatus;