"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePageSlice = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @description given an array index and page size, returns a slice of said array.
 */
const usePageSlice = (data, pageIndex, pageSize) => {
  return (0, _react.useMemo)(() => {
    if (!data) {
      return [];
    }
    const cursor = pageIndex * pageSize;
    return data.slice(cursor, cursor + pageSize);
  }, [data, pageIndex, pageSize]);
};
exports.usePageSlice = usePageSlice;