"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataView = void 0;
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to retrieve a Data View by it's Index Pattern title
 */
const useDataView = indexPattern => {
  const {
    data: {
      dataViews
    }
  } = (0, _public.useKibana)().services;
  return (0, _reactQuery.useQuery)(['useDataView', indexPattern], async () => {
    const [dataView] = await dataViews.find(indexPattern);
    if (!dataView) {
      throw new Error(`Data view not found [${indexPattern}]`);
    }
    return dataView;
  });
};
exports.useDataView = useDataView;