"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VULN_MGMT_POLICY_TEMPLATE = exports.VULNERABILITIES_SEVERITY = exports.VULNERABILITIES_INDEX_PATTERN = exports.VULNERABILITIES_INDEX_NAME = exports.VULNERABILITIES_INDEX_DEFAULT_NS = exports.VULNERABILITIES_ENUMERATION = exports.VULNERABILITIES_DASHBOARD_ROUTE_PATH = exports.VULNERABILITIES = exports.TEMPLATE_URL_ACCOUNT_TYPE_ENV_VAR = exports.SUPPORTED_POLICY_TEMPLATES = exports.SUPPORTED_CLOUDBEAT_INPUTS = exports.STATUS_ROUTE_PATH = exports.STATUS_API_CURRENT_VERSION = exports.STATS_ROUTE_PATH = exports.SINGLE_ACCOUNT = exports.SECURITY_DEFAULT_DATA_VIEW_ID = exports.RULE_PASSED = exports.RULE_FAILED = exports.POSTURE_TYPE_ALL = exports.POSTURE_TYPES = exports.ORGANIZATION_ACCOUNT = exports.LATEST_VULNERABILITIES_RETENTION_POLICY = exports.LATEST_VULNERABILITIES_INDEX_TEMPLATE_NAME = exports.LATEST_VULNERABILITIES_INDEX_PATTERN = exports.LATEST_VULNERABILITIES_INDEX_DEFAULT_NS = exports.LATEST_FINDINGS_RETENTION_POLICY = exports.LATEST_FINDINGS_INDEX_TEMPLATE_NAME = exports.LATEST_FINDINGS_INDEX_PATTERN = exports.LATEST_FINDINGS_INDEX_DEFAULT_NS = exports.KSPM_POLICY_TEMPLATE = exports.INTERNAL_FEATURE_FLAGS = exports.INTERNAL_CSP_SETTINGS_SAVED_OBJECT_TYPE = exports.INTERNAL_CSP_SETTINGS_SAVED_OBJECT_ID = exports.GET_DETECTION_RULE_ALERTS_STATUS_PATH = exports.GCP_CREDENTIALS_TYPE_TO_FIELDS_MAP = exports.FIND_CSP_BENCHMARK_RULE_ROUTE_PATH = exports.FIND_CSP_BENCHMARK_RULE_API_CURRENT_VERSION = exports.FINDINGS_INDEX_PATTERN = exports.FINDINGS_INDEX_NAME = exports.FINDINGS_INDEX_DEFAULT_NS = exports.DETECTION_RULE_RULES_API_CURRENT_VERSION = exports.DETECTION_RULE_ALERTS_STATUS_API_CURRENT_VERSION = exports.DETECTION_ENGINE_ALERTS_INDEX_DEFAULT = exports.DATA_VIEW_INDEX_PATTERN = exports.CSP_LATEST_VULNERABILITIES_INGEST_TIMESTAMP_PIPELINE = exports.CSP_LATEST_FINDINGS_INGEST_TIMESTAMP_PIPELINE = exports.CSP_LATEST_FINDINGS_DATA_VIEW = exports.CSP_INGEST_TIMESTAMP_PIPELINE = exports.CSP_GET_BENCHMARK_RULES_STATE_ROUTE_PATH = exports.CSP_GET_BENCHMARK_RULES_STATE_API_CURRENT_VERSION = exports.CSP_BENCHMARK_RULE_SAVED_OBJECT_TYPE = exports.CSP_BENCHMARK_RULES_BULK_ACTION_ROUTE_PATH = exports.CSP_BENCHMARK_RULES_BULK_ACTION_API_CURRENT_VERSION = exports.CSPM_POLICY_TEMPLATE = exports.CSPM_FINDINGS_STATS_INTERVAL = exports.CONFIGURATIONS = exports.CNVM_POLICY_TEMPLATE = exports.CLOUD_SECURITY_POSTURE_PACKAGE_NAME = exports.CLOUD_SECURITY_PLUGIN_VERSION = exports.CLOUD_FORMATION_STACK_NAME = exports.CLOUD_CREDENTIALS_PACKAGE_VERSION = exports.CLOUDBEAT_VULN_MGMT_GCP = exports.CLOUDBEAT_VULN_MGMT_AZURE = exports.CLOUDBEAT_VULN_MGMT_AWS = exports.CLOUDBEAT_VANILLA = exports.CLOUDBEAT_GKE = exports.CLOUDBEAT_GCP = exports.CLOUDBEAT_EKS = exports.CLOUDBEAT_AZURE = exports.CLOUDBEAT_AWS = exports.CLOUDBEAT_AKS = exports.CIS_K8S = exports.CIS_GCP = exports.CIS_EKS = exports.CIS_AZURE = exports.CIS_AWS = exports.BENCHMARK_SCORE_INDEX_TEMPLATE_NAME = exports.BENCHMARK_SCORE_INDEX_PATTERN = exports.BENCHMARK_SCORE_INDEX_DEFAULT_NS = exports.BENCHMARKS_ROUTE_PATH = exports.BENCHMARKS_API_CURRENT_VERSION = exports.AZURE_CREDENTIALS_TYPE_TO_FIELDS_MAP = exports.AWS_CREDENTIALS_TYPE_TO_FIELDS_MAP = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUS_ROUTE_PATH = exports.STATUS_ROUTE_PATH = '/internal/cloud_security_posture/status';
const STATUS_API_CURRENT_VERSION = exports.STATUS_API_CURRENT_VERSION = '1';
const STATS_ROUTE_PATH = exports.STATS_ROUTE_PATH = '/internal/cloud_security_posture/stats/{policy_template}';
const VULNERABILITIES_DASHBOARD_ROUTE_PATH = exports.VULNERABILITIES_DASHBOARD_ROUTE_PATH = '/internal/cloud_security_posture/vulnerabilities_dashboard';
const BENCHMARKS_ROUTE_PATH = exports.BENCHMARKS_ROUTE_PATH = '/internal/cloud_security_posture/benchmarks';
const BENCHMARKS_API_CURRENT_VERSION = exports.BENCHMARKS_API_CURRENT_VERSION = '1';
const FIND_CSP_BENCHMARK_RULE_ROUTE_PATH = exports.FIND_CSP_BENCHMARK_RULE_ROUTE_PATH = '/internal/cloud_security_posture/rules/_find';
const FIND_CSP_BENCHMARK_RULE_API_CURRENT_VERSION = exports.FIND_CSP_BENCHMARK_RULE_API_CURRENT_VERSION = '1';
const CSP_BENCHMARK_RULES_BULK_ACTION_ROUTE_PATH = exports.CSP_BENCHMARK_RULES_BULK_ACTION_ROUTE_PATH = '/internal/cloud_security_posture/rules/_bulk_action';
const CSP_BENCHMARK_RULES_BULK_ACTION_API_CURRENT_VERSION = exports.CSP_BENCHMARK_RULES_BULK_ACTION_API_CURRENT_VERSION = '1';
const CSP_GET_BENCHMARK_RULES_STATE_ROUTE_PATH = exports.CSP_GET_BENCHMARK_RULES_STATE_ROUTE_PATH = '/internal/cloud_security_posture/rules/_get_states';
const CSP_GET_BENCHMARK_RULES_STATE_API_CURRENT_VERSION = exports.CSP_GET_BENCHMARK_RULES_STATE_API_CURRENT_VERSION = '1';
const GET_DETECTION_RULE_ALERTS_STATUS_PATH = exports.GET_DETECTION_RULE_ALERTS_STATUS_PATH = '/internal/cloud_security_posture/detection_engine_rules/alerts/_status';
const DETECTION_RULE_ALERTS_STATUS_API_CURRENT_VERSION = exports.DETECTION_RULE_ALERTS_STATUS_API_CURRENT_VERSION = '1';
const DETECTION_RULE_RULES_API_CURRENT_VERSION = exports.DETECTION_RULE_RULES_API_CURRENT_VERSION = '2023-10-31';
const CLOUD_SECURITY_POSTURE_PACKAGE_NAME = exports.CLOUD_SECURITY_POSTURE_PACKAGE_NAME = 'cloud_security_posture';
// TODO: REMOVE CSP_LATEST_FINDINGS_DATA_VIEW and replace it with LATEST_FINDINGS_INDEX_PATTERN
const CSP_LATEST_FINDINGS_DATA_VIEW = exports.CSP_LATEST_FINDINGS_DATA_VIEW = 'logs-cloud_security_posture.findings_latest-*';
const FINDINGS_INDEX_NAME = exports.FINDINGS_INDEX_NAME = 'logs-cloud_security_posture.findings';
const FINDINGS_INDEX_PATTERN = exports.FINDINGS_INDEX_PATTERN = 'logs-cloud_security_posture.findings-default*';
const FINDINGS_INDEX_DEFAULT_NS = exports.FINDINGS_INDEX_DEFAULT_NS = 'logs-cloud_security_posture.findings-default';
const LATEST_FINDINGS_INDEX_TEMPLATE_NAME = exports.LATEST_FINDINGS_INDEX_TEMPLATE_NAME = 'logs-cloud_security_posture.findings_latest';
const LATEST_FINDINGS_INDEX_PATTERN = exports.LATEST_FINDINGS_INDEX_PATTERN = 'logs-cloud_security_posture.findings_latest-*';
const LATEST_FINDINGS_INDEX_DEFAULT_NS = exports.LATEST_FINDINGS_INDEX_DEFAULT_NS = 'logs-cloud_security_posture.findings_latest-default';
const LATEST_FINDINGS_RETENTION_POLICY = exports.LATEST_FINDINGS_RETENTION_POLICY = '26h';
const BENCHMARK_SCORE_INDEX_TEMPLATE_NAME = exports.BENCHMARK_SCORE_INDEX_TEMPLATE_NAME = 'logs-cloud_security_posture.scores';
const BENCHMARK_SCORE_INDEX_PATTERN = exports.BENCHMARK_SCORE_INDEX_PATTERN = 'logs-cloud_security_posture.scores-*';
const BENCHMARK_SCORE_INDEX_DEFAULT_NS = exports.BENCHMARK_SCORE_INDEX_DEFAULT_NS = 'logs-cloud_security_posture.scores-default';
const VULNERABILITIES_INDEX_NAME = exports.VULNERABILITIES_INDEX_NAME = 'logs-cloud_security_posture.vulnerabilities';
const VULNERABILITIES_INDEX_PATTERN = exports.VULNERABILITIES_INDEX_PATTERN = 'logs-cloud_security_posture.vulnerabilities-default*';
const VULNERABILITIES_INDEX_DEFAULT_NS = exports.VULNERABILITIES_INDEX_DEFAULT_NS = 'logs-cloud_security_posture.vulnerabilities-default';
const LATEST_VULNERABILITIES_INDEX_TEMPLATE_NAME = exports.LATEST_VULNERABILITIES_INDEX_TEMPLATE_NAME = 'logs-cloud_security_posture.vulnerabilities_latest';
const LATEST_VULNERABILITIES_INDEX_PATTERN = exports.LATEST_VULNERABILITIES_INDEX_PATTERN = 'logs-cloud_security_posture.vulnerabilities_latest*';
const LATEST_VULNERABILITIES_INDEX_DEFAULT_NS = exports.LATEST_VULNERABILITIES_INDEX_DEFAULT_NS = 'logs-cloud_security_posture.vulnerabilities_latest-default';
const LATEST_VULNERABILITIES_RETENTION_POLICY = exports.LATEST_VULNERABILITIES_RETENTION_POLICY = '3d';
const DATA_VIEW_INDEX_PATTERN = exports.DATA_VIEW_INDEX_PATTERN = 'logs-*';
const SECURITY_DEFAULT_DATA_VIEW_ID = exports.SECURITY_DEFAULT_DATA_VIEW_ID = 'security-solution-default';
const CSP_INGEST_TIMESTAMP_PIPELINE = exports.CSP_INGEST_TIMESTAMP_PIPELINE = 'cloud_security_posture_add_ingest_timestamp_pipeline';
const CSP_LATEST_FINDINGS_INGEST_TIMESTAMP_PIPELINE = exports.CSP_LATEST_FINDINGS_INGEST_TIMESTAMP_PIPELINE = 'cloud_security_posture_latest_index_add_ingest_timestamp_pipeline';
const CSP_LATEST_VULNERABILITIES_INGEST_TIMESTAMP_PIPELINE = exports.CSP_LATEST_VULNERABILITIES_INGEST_TIMESTAMP_PIPELINE = 'cloud_security_posture_latest_vulnerabilities_index_add_ingest_timestamp_pipeline';
const RULE_PASSED = exports.RULE_PASSED = `passed`;
const RULE_FAILED = exports.RULE_FAILED = `failed`;
const POSTURE_TYPE_ALL = exports.POSTURE_TYPE_ALL = 'all';
const CSPM_FINDINGS_STATS_INTERVAL = exports.CSPM_FINDINGS_STATS_INTERVAL = 5;

// A mapping of in-development features to their status. These features should be hidden from users but can be easily
// activated via a simple code change in a single location.
const INTERNAL_FEATURE_FLAGS = exports.INTERNAL_FEATURE_FLAGS = {
  showManageRulesMock: false,
  showFindingFlyoutEvidence: true
};
const CSP_BENCHMARK_RULE_SAVED_OBJECT_TYPE = exports.CSP_BENCHMARK_RULE_SAVED_OBJECT_TYPE = 'csp-rule-template';
const INTERNAL_CSP_SETTINGS_SAVED_OBJECT_TYPE = exports.INTERNAL_CSP_SETTINGS_SAVED_OBJECT_TYPE = 'cloud-security-posture-settings';
const INTERNAL_CSP_SETTINGS_SAVED_OBJECT_ID = exports.INTERNAL_CSP_SETTINGS_SAVED_OBJECT_ID = 'csp-internal-settings';
const CLOUDBEAT_VANILLA = exports.CLOUDBEAT_VANILLA = 'cloudbeat/cis_k8s';
const CLOUDBEAT_EKS = exports.CLOUDBEAT_EKS = 'cloudbeat/cis_eks';
const CLOUDBEAT_AKS = exports.CLOUDBEAT_AKS = 'cloudbeat/cis_aks';
const CLOUDBEAT_GKE = exports.CLOUDBEAT_GKE = 'cloudbeat/cis_gke';
const CLOUDBEAT_AWS = exports.CLOUDBEAT_AWS = 'cloudbeat/cis_aws';
const CLOUDBEAT_GCP = exports.CLOUDBEAT_GCP = 'cloudbeat/cis_gcp';
const CLOUDBEAT_AZURE = exports.CLOUDBEAT_AZURE = 'cloudbeat/cis_azure';
const CLOUDBEAT_VULN_MGMT_AWS = exports.CLOUDBEAT_VULN_MGMT_AWS = 'cloudbeat/vuln_mgmt_aws';
const CLOUDBEAT_VULN_MGMT_GCP = exports.CLOUDBEAT_VULN_MGMT_GCP = 'cloudbeat/vuln_mgmt_gcp';
const CLOUDBEAT_VULN_MGMT_AZURE = exports.CLOUDBEAT_VULN_MGMT_AZURE = 'cloudbeat/vuln_mgmt_azure';
const CIS_AWS = exports.CIS_AWS = 'cis_aws';
const CIS_GCP = exports.CIS_GCP = 'cis_gcp';
const CIS_K8S = exports.CIS_K8S = 'cis_k8s';
const CIS_EKS = exports.CIS_EKS = 'cis_eks';
const CIS_AZURE = exports.CIS_AZURE = 'cis_azure';
const KSPM_POLICY_TEMPLATE = exports.KSPM_POLICY_TEMPLATE = 'kspm';
const CSPM_POLICY_TEMPLATE = exports.CSPM_POLICY_TEMPLATE = 'cspm';
const VULN_MGMT_POLICY_TEMPLATE = exports.VULN_MGMT_POLICY_TEMPLATE = 'vuln_mgmt';
const CNVM_POLICY_TEMPLATE = exports.CNVM_POLICY_TEMPLATE = 'cnvm';
const SUPPORTED_POLICY_TEMPLATES = exports.SUPPORTED_POLICY_TEMPLATES = [KSPM_POLICY_TEMPLATE, CSPM_POLICY_TEMPLATE, VULN_MGMT_POLICY_TEMPLATE];
const SUPPORTED_CLOUDBEAT_INPUTS = exports.SUPPORTED_CLOUDBEAT_INPUTS = [CLOUDBEAT_VANILLA, CLOUDBEAT_EKS, CLOUDBEAT_AWS, CLOUDBEAT_GCP, CLOUDBEAT_AZURE, CLOUDBEAT_VULN_MGMT_AWS, CLOUDBEAT_VULN_MGMT_GCP, CLOUDBEAT_VULN_MGMT_AZURE];
const POSTURE_TYPES = exports.POSTURE_TYPES = {
  [KSPM_POLICY_TEMPLATE]: KSPM_POLICY_TEMPLATE,
  [CSPM_POLICY_TEMPLATE]: CSPM_POLICY_TEMPLATE,
  [VULN_MGMT_POLICY_TEMPLATE]: VULN_MGMT_POLICY_TEMPLATE,
  [POSTURE_TYPE_ALL]: POSTURE_TYPE_ALL
};
const VULNERABILITIES = exports.VULNERABILITIES = 'vulnerabilities';
const CONFIGURATIONS = exports.CONFIGURATIONS = 'configurations';
const VULNERABILITIES_SEVERITY = exports.VULNERABILITIES_SEVERITY = {
  LOW: 'LOW',
  MEDIUM: 'MEDIUM',
  HIGH: 'HIGH',
  CRITICAL: 'CRITICAL',
  UNKNOWN: 'UNKNOWN'
};
const VULNERABILITIES_ENUMERATION = exports.VULNERABILITIES_ENUMERATION = 'CVE';
const AWS_CREDENTIALS_TYPE_TO_FIELDS_MAP = exports.AWS_CREDENTIALS_TYPE_TO_FIELDS_MAP = {
  assume_role: ['role_arn'],
  direct_access_keys: ['access_key_id', 'secret_access_key'],
  temporary_keys: ['access_key_id', 'secret_access_key', 'session_token'],
  shared_credentials: ['shared_credential_file', 'credential_profile_name'],
  cloud_formation: []
};
const DETECTION_ENGINE_ALERTS_INDEX_DEFAULT = exports.DETECTION_ENGINE_ALERTS_INDEX_DEFAULT = '.alerts-security.alerts-default';
const GCP_CREDENTIALS_TYPE_TO_FIELDS_MAP = exports.GCP_CREDENTIALS_TYPE_TO_FIELDS_MAP = {
  'credentials-none': [],
  'credentials-file': ['gcp.credentials.file'],
  'credentials-json': ['gcp.credentials.json']
};
const AZURE_CREDENTIALS_TYPE_TO_FIELDS_MAP = exports.AZURE_CREDENTIALS_TYPE_TO_FIELDS_MAP = {
  arm_template: [],
  service_principal_with_client_secret: ['azure.credentials.tenant_id', 'azure.credentials.client_id', 'azure.credentials.client_secret'],
  service_principal_with_client_certificate: ['azure.credentials.tenant_id', 'azure.credentials.client_id', 'azure.credentials.client_certificate_path', 'azure.credentials.client_certificate_password'],
  service_principal_with_client_username_and_password: ['azure.credentials.tenant_id', 'azure.credentials.client_id', 'azure.credentials.client_username', 'azure.credentials.client_password'],
  managed_identity: [],
  manual: []
};
const CLOUD_FORMATION_STACK_NAME = exports.CLOUD_FORMATION_STACK_NAME = 'Elastic-Cloud-Security-Posture-Management';
const TEMPLATE_URL_ACCOUNT_TYPE_ENV_VAR = exports.TEMPLATE_URL_ACCOUNT_TYPE_ENV_VAR = 'ACCOUNT_TYPE';
const ORGANIZATION_ACCOUNT = exports.ORGANIZATION_ACCOUNT = 'organization-account';
const SINGLE_ACCOUNT = exports.SINGLE_ACCOUNT = 'single-account';
const CLOUD_SECURITY_PLUGIN_VERSION = exports.CLOUD_SECURITY_PLUGIN_VERSION = '1.9.0';
// Cloud Credentials Template url was implemented in 1.10.0-preview01. See PR - https://github.com/elastic/integrations/pull/9828
const CLOUD_CREDENTIALS_PACKAGE_VERSION = exports.CLOUD_CREDENTIALS_PACKAGE_VERSION = '1.10.0-preview01';