"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _register_cloud_deployment_id_analytics_context = require("../common/register_cloud_deployment_id_analytics_context");
var _is_cloud_enabled = require("../common/is_cloud_enabled");
var _parse_deployment_id_from_deployment_url = require("../common/parse_deployment_id_from_deployment_url");
var _constants = require("../common/constants");
var _decode_cloud_id = require("../common/decode_cloud_id");
var _utils = require("../common/utils");
var _parse_onboarding_default_solution = require("../common/parse_onboarding_default_solution");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CloudPlugin {
  constructor(initializerContext) {
    var _this$config$serverle;
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "isCloudEnabled", void 0);
    (0, _defineProperty2.default)(this, "isServerlessEnabled", void 0);
    (0, _defineProperty2.default)(this, "contextProviders", []);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.isCloudEnabled = (0, _is_cloud_enabled.getIsCloudEnabled)(this.config.id);
    this.isServerlessEnabled = !!((_this$config$serverle = this.config.serverless) !== null && _this$config$serverle !== void 0 && _this$config$serverle.project_id);
    this.logger = initializerContext.logger.get();
  }
  setup(core) {
    var _decodedId, _decodedId2, _decodedId3, _decodedId4, _this$config$onboardi, _this$config$serverle2, _this$config$serverle3, _this$config$serverle4;
    (0, _register_cloud_deployment_id_analytics_context.registerCloudDeploymentMetadataAnalyticsContext)(core.analytics, this.config);
    const {
      id,
      cname,
      base_url: baseUrl,
      trial_end_date: trialEndDate,
      is_elastic_staff_owned: isElasticStaffOwned
    } = this.config;
    let decodedId;
    if (id) {
      decodedId = (0, _decode_cloud_id.decodeCloudId)(id, this.logger);
    }
    return {
      cloudId: id,
      deploymentId: (0, _parse_deployment_id_from_deployment_url.parseDeploymentIdFromDeploymentUrl)(this.config.deployment_url),
      cname,
      baseUrl,
      ...this.getCloudUrls(),
      elasticsearchUrl: (_decodedId = decodedId) === null || _decodedId === void 0 ? void 0 : _decodedId.elasticsearchUrl,
      kibanaUrl: (_decodedId2 = decodedId) === null || _decodedId2 === void 0 ? void 0 : _decodedId2.kibanaUrl,
      cloudHost: (_decodedId3 = decodedId) === null || _decodedId3 === void 0 ? void 0 : _decodedId3.host,
      cloudDefaultPort: (_decodedId4 = decodedId) === null || _decodedId4 === void 0 ? void 0 : _decodedId4.defaultPort,
      trialEndDate: trialEndDate ? new Date(trialEndDate) : undefined,
      isElasticStaffOwned,
      isCloudEnabled: this.isCloudEnabled,
      onboarding: {
        defaultSolution: (0, _parse_onboarding_default_solution.parseOnboardingSolution)((_this$config$onboardi = this.config.onboarding) === null || _this$config$onboardi === void 0 ? void 0 : _this$config$onboardi.default_solution)
      },
      isServerlessEnabled: this.isServerlessEnabled,
      serverless: {
        projectId: (_this$config$serverle2 = this.config.serverless) === null || _this$config$serverle2 === void 0 ? void 0 : _this$config$serverle2.project_id,
        projectName: (_this$config$serverle3 = this.config.serverless) === null || _this$config$serverle3 === void 0 ? void 0 : _this$config$serverle3.project_name,
        projectType: (_this$config$serverle4 = this.config.serverless) === null || _this$config$serverle4 === void 0 ? void 0 : _this$config$serverle4.project_type
      },
      registerCloudService: contextProvider => {
        this.contextProviders.push(contextProvider);
      }
    };
  }
  start(coreStart) {
    var _decodedId5, _decodedId6, _this$config$serverle5, _this$config$serverle6, _this$config$serverle7;
    coreStart.chrome.setHelpSupportUrl((0, _utils2.getSupportUrl)(this.config));

    // Nest all the registered context providers under the Cloud Services Provider.
    // This way, plugins only need to require Cloud's context provider to have all the enriched Cloud services.
    const CloudContextProvider = ({
      children
    }) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.contextProviders.reduce((acc, ContextProvider) => /*#__PURE__*/_react.default.createElement(ContextProvider, null, " ", acc, " "), children));
    };
    const {
      deploymentsUrl,
      deploymentUrl,
      profileUrl,
      billingUrl,
      organizationUrl,
      performanceUrl,
      usersAndRolesUrl,
      projectsUrl
    } = this.getCloudUrls();
    let decodedId;
    if (this.config.id) {
      decodedId = (0, _decode_cloud_id.decodeCloudId)(this.config.id, this.logger);
    }
    return {
      CloudContextProvider,
      isCloudEnabled: this.isCloudEnabled,
      cloudId: this.config.id,
      billingUrl,
      deploymentsUrl,
      deploymentUrl,
      profileUrl,
      organizationUrl,
      projectsUrl,
      elasticsearchUrl: (_decodedId5 = decodedId) === null || _decodedId5 === void 0 ? void 0 : _decodedId5.elasticsearchUrl,
      kibanaUrl: (_decodedId6 = decodedId) === null || _decodedId6 === void 0 ? void 0 : _decodedId6.kibanaUrl,
      isServerlessEnabled: this.isServerlessEnabled,
      serverless: {
        projectId: (_this$config$serverle5 = this.config.serverless) === null || _this$config$serverle5 === void 0 ? void 0 : _this$config$serverle5.project_id,
        projectName: (_this$config$serverle6 = this.config.serverless) === null || _this$config$serverle6 === void 0 ? void 0 : _this$config$serverle6.project_name,
        projectType: (_this$config$serverle7 = this.config.serverless) === null || _this$config$serverle7 === void 0 ? void 0 : _this$config$serverle7.project_type
      },
      performanceUrl,
      usersAndRolesUrl
    };
  }
  stop() {}
  getCloudUrls() {
    const {
      profile_url: profileUrl,
      billing_url: billingUrl,
      organization_url: organizationUrl,
      deployments_url: deploymentsUrl,
      deployment_url: deploymentUrl,
      base_url: baseUrl,
      performance_url: performanceUrl,
      users_and_roles_url: usersAndRolesUrl,
      projects_url: projectsUrl
    } = this.config;
    const fullCloudDeploymentsUrl = (0, _utils.getFullCloudUrl)(baseUrl, deploymentsUrl);
    const fullCloudDeploymentUrl = (0, _utils.getFullCloudUrl)(baseUrl, deploymentUrl);
    const fullCloudProfileUrl = (0, _utils.getFullCloudUrl)(baseUrl, profileUrl);
    const fullCloudBillingUrl = (0, _utils.getFullCloudUrl)(baseUrl, billingUrl);
    const fullCloudOrganizationUrl = (0, _utils.getFullCloudUrl)(baseUrl, organizationUrl);
    const fullCloudPerformanceUrl = (0, _utils.getFullCloudUrl)(baseUrl, performanceUrl);
    const fullCloudUsersAndRolesUrl = (0, _utils.getFullCloudUrl)(baseUrl, usersAndRolesUrl);
    const fullCloudProjectsUrl = (0, _utils.getFullCloudUrl)(baseUrl, projectsUrl);
    const fullCloudSnapshotsUrl = `${fullCloudDeploymentUrl}/${_constants.CLOUD_SNAPSHOTS_PATH}`;
    return {
      deploymentsUrl: fullCloudDeploymentsUrl,
      deploymentUrl: fullCloudDeploymentUrl,
      profileUrl: fullCloudProfileUrl,
      billingUrl: fullCloudBillingUrl,
      organizationUrl: fullCloudOrganizationUrl,
      snapshotsUrl: fullCloudSnapshotsUrl,
      performanceUrl: fullCloudPerformanceUrl,
      usersAndRolesUrl: fullCloudUsersAndRolesUrl,
      projectsUrl: fullCloudProjectsUrl
    };
  }
}
exports.CloudPlugin = CloudPlugin;