"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudLinksPlugin = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var connectionDetails = _interopRequireWildcard(require("@kbn/cloud/connection_details"));
var _maybe_add_cloud_links = require("./maybe_add_cloud_links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CloudLinksPlugin {
  setup({
    analytics
  }) {
    analytics.registerEventType({
      eventType: 'connection_details_learn_more_clicked',
      schema: {}
    });
    analytics.registerEventType({
      eventType: 'connection_details_tab_switched',
      schema: {
        tab: {
          type: 'keyword',
          _meta: {
            description: 'Connection details tab that was switched to.',
            optional: false
          }
        }
      }
    });
    analytics.registerEventType({
      eventType: 'connection_details_copy_endpoint_url_clicked',
      schema: {}
    });
    analytics.registerEventType({
      eventType: 'connection_details_show_cloud_id_toggled',
      schema: {}
    });
    analytics.registerEventType({
      eventType: 'connection_details_copy_cloud_id_clicked',
      schema: {}
    });
    analytics.registerEventType({
      eventType: 'connection_details_new_api_key_created',
      schema: {}
    });
    analytics.registerEventType({
      eventType: 'connection_details_manage_api_keys_clicked',
      schema: {}
    });
    analytics.registerEventType({
      eventType: 'connection_details_key_encoding_changed',
      schema: {
        format: {
          type: 'keyword',
          _meta: {
            description: 'The format of the API key that was changed to.',
            optional: false
          }
        }
      }
    });
    analytics.registerEventType({
      eventType: 'connection_details_copy_api_key_clicked',
      schema: {
        format: {
          type: 'keyword',
          _meta: {
            description: 'The format of the API key that was copied.',
            optional: false
          }
        }
      }
    });
  }
  start(core, plugins) {
    const {
      cloud,
      security,
      guidedOnboarding,
      share
    } = plugins;
    if (cloud !== null && cloud !== void 0 && cloud.isCloudEnabled && !core.http.anonymousPaths.isAnonymous(window.location.pathname)) {
      var _guidedOnboarding$gui;
      if (guidedOnboarding !== null && guidedOnboarding !== void 0 && (_guidedOnboarding$gui = guidedOnboarding.guidedOnboardingApi) !== null && _guidedOnboarding$gui !== void 0 && _guidedOnboarding$gui.isEnabled) {
        core.chrome.registerGlobalHelpExtensionMenuLink({
          linkType: 'custom',
          href: core.http.basePath.prepend('/app/home#/getting_started'),
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.cloudLinks.setupGuide",
            defaultMessage: "Setup guides"
          }),
          'data-test-subj': 'cloudOnboardingSetupGuideLink',
          priority: 1000 // We want this link to be at the very top.
        });
      }
      if (security) {
        (0, _maybe_add_cloud_links.maybeAddCloudLinks)({
          core,
          security,
          cloud,
          share
        });
      }
    }
    connectionDetails.setGlobalDependencies({
      start: {
        core,
        plugins
      }
    });
  }
  stop() {}
}
exports.CloudLinksPlugin = CloudLinksPlugin;