"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LaunchDarklyClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class LaunchDarklyClient {
  constructor(ldConfig, kibanaVersion, logger) {
    (0, _defineProperty2.default)(this, "initialized", false);
    (0, _defineProperty2.default)(this, "canceled", false);
    (0, _defineProperty2.default)(this, "launchDarklyClientSub$", new _rxjs.BehaviorSubject(null));
    (0, _defineProperty2.default)(this, "loadingClient$", new _rxjs.BehaviorSubject(true));
    (0, _defineProperty2.default)(this, "launchDarklyClient$", this.loadingClient$.pipe(
    // To avoid a racing condition when trying to get a variation before the client is ready
    // we use the `switchMap` operator to ensure we only return the client when it has been initialized.
    (0, _rxjs.filter)(loading => !loading), (0, _rxjs.switchMap)(() => this.launchDarklyClientSub$)));
    this.ldConfig = ldConfig;
    this.kibanaVersion = kibanaVersion;
    this.logger = logger;
  }
  async updateUserMetadata(userMetadata) {
    if (this.canceled) return;
    const {
      userId,
      ...userMetadataWithoutUserId
    } = userMetadata;
    const launchDarklyUser = {
      ...userMetadataWithoutUserId,
      kind: 'user',
      key: userId
    };
    let launchDarklyClient = null;
    if (this.initialized) {
      launchDarklyClient = await this.getClient();
    }
    if (launchDarklyClient) {
      await launchDarklyClient.identify(launchDarklyUser);
    } else {
      this.initialized = true;
      const {
        initialize,
        basicLogger
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('launchdarkly-js-client-sdk')));
      launchDarklyClient = initialize(this.ldConfig.client_id, launchDarklyUser, {
        application: {
          id: 'kibana-browser',
          version: this.kibanaVersion
        },
        logger: basicLogger({
          level: this.ldConfig.client_log_level
        })
      });
      this.launchDarklyClientSub$.next(launchDarklyClient);
      this.loadingClient$.next(false);
    }
  }
  async getVariation(configKey, defaultValue) {
    const launchDarklyClient = await this.getClient();
    if (!launchDarklyClient) return defaultValue; // Skip any action if no LD User is defined
    await launchDarklyClient.waitForInitialization();
    return await launchDarklyClient.variation(configKey, defaultValue);
  }
  reportMetric(metricName, meta, value) {
    this.getClient().then(launchDarklyClient => {
      if (!launchDarklyClient) return; // Skip any action if no LD User is defined
      launchDarklyClient.track(metricName, meta, value);
    });
  }
  stop() {
    this.getClient().then(launchDarklyClient => {
      launchDarklyClient === null || launchDarklyClient === void 0 ? void 0 : launchDarklyClient.flush().catch(err => {
        this.logger.warn(err);
      });
    });
  }
  cancel() {
    this.initialized = true;
    this.canceled = true;
    this.loadingClient$.next(false);
  }
  getClient() {
    return (0, _rxjs.firstValueFrom)(this.launchDarklyClient$, {
      defaultValue: null
    });
  }
}
exports.LaunchDarklyClient = LaunchDarklyClient;