/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.cloudDefend_bundle_jsonpfunction=window.cloudDefend_bundle_jsonpfunction||[]).push([[4],{70:function(e){e.exports=JSON.parse('{"$id":"https://elastic.co/cloud-defend/policy-schema.json","$schema":"http://json-schema.org/draft-07/schema#","$comment":"policy-version=1.0.0","type":"object","anyOf":[{"required":["file"]},{"required":["process"]}],"additionalProperties":true,"properties":{"version":{"type":"string"},"file":{"type":"object","required":["selectors","responses"],"properties":{"selectors":{"type":"array","minItems":1,"items":{"$ref":"#/$defs/fileSelector"}},"responses":{"type":"array","minItems":1,"items":{"$ref":"#/$defs/fileResponse"}}}},"process":{"type":"object","required":["selectors","responses"],"properties":{"selectors":{"type":"array","minItems":1,"items":{"$ref":"#/$defs/processSelector"}},"responses":{"type":"array","minItems":1,"items":{"$ref":"#/$defs/processResponse"}}}}},"$defs":{"fileSelector":{"type":"object","required":["name"],"additionalProperties":true,"anyOf":[{"required":["operation"]},{"required":["containerImageName"]},{"required":["containerImageTag"]},{"required":["containerImageFullName"]},{"required":["kubernetesClusterId"]},{"required":["kubernetesClusterName"]},{"required":["kubernetesNamespace"]},{"required":["kubernetesPodLabel"]},{"required":["kubernetesPodName"]},{"required":["targetFilePath"]},{"required":["ignoreVolumeMounts"]},{"required":["ignoreVolumeFiles"]}],"properties":{"name":{"type":"string"},"operation":{"type":"array","minItems":1,"items":{"enum":["createExecutable","modifyExecutable","createFile","modifyFile","deleteFile"]}},"containerImageName":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^([a-z0-9]+(?:[._-][a-z0-9]+)*)$"}},"containerImageTag":{"type":"array","minItems":1,"items":{"type":"string"}},"containerImageFullName":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^(?:\\\\[[a-fA-F0-9:]+\\\\]|(?:[a-zA-Z0-9-](?:\\\\.[a-z0-9]+)*)+)(?::[0-9]+)?(?:\\\\/[a-z0-9]+(?:[._-][a-z0-9]+)*)+$"}},"kubernetesClusterId":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesClusterName":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesNamespace":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesPodLabel":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^([a-zA-Z0-9\\\\.\\\\-]+\\\\/)?[a-zA-Z0-9\\\\.\\\\-]+:[a-zA-Z0-9\\\\.\\\\-\\\\_]*\\\\*?$"}},"kubernetesPodName":{"type":"array","minItems":1,"items":{"type":"string"}},"targetFilePath":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^(?:\\\\/[^\\\\/\\\\*]+)*(?:\\\\/\\\\*|\\\\/\\\\*\\\\*)?$","minLength":1}},"ignoreVolumeMounts":{"type":"boolean","description":"Ignore all volume mounts. e.g directories, files, configMaps, secrets etc...\\nNote: should not be used with ignoreVolumeFiles"},"ignoreVolumeFiles":{"type":"boolean","description":"Ignore file mounts. e.g files, configMaps, secrets\\nNote: should not be used with ignoreVolumeMounts"}},"dependencies":{"ignoreVolumeMounts":{"not":{"required":["ignoreVolumeFiles"]}},"containerImageFullName":{"not":{"required":["containerImageName"]}}}},"processSelector":{"type":"object","required":["name"],"additionalProperties":true,"anyOf":[{"required":["operation"]},{"required":["containerImageName"]},{"required":["containerImageTag"]},{"required":["containerImageFullName"]},{"required":["kubernetesClusterId"]},{"required":["kubernetesClusterName"]},{"required":["kubernetesNamespace"]},{"required":["kubernetesPodLabel"]},{"required":["kubernetesPodName"]},{"required":["processExecutable"]},{"required":["processName"]},{"required":["sessionLeaderInteractive"]}],"properties":{"name":{"type":"string"},"operation":{"type":"array","minItems":1,"items":{"enum":["fork","exec"]}},"containerImageName":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^[a-z0-9]+(?:[._-][a-z0-9]+)*$"}},"containerImageTag":{"type":"array","minItems":1,"items":{"type":"string"}},"containerImageFullName":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^(?:\\\\[[a-fA-F0-9:]+\\\\]|(?:[a-zA-Z0-9-](?:\\\\.[a-z0-9]+)*)+)(?::[0-9]+)?(?:\\\\/[a-z0-9]+(?:[._-][a-z0-9]+)*)+$"}},"kubernetesClusterId":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesClusterName":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesNamespace":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesPodLabel":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^([a-zA-Z0-9\\\\.\\\\-]+\\\\/)?[a-zA-Z0-9\\\\.\\\\-]+:[a-zA-Z0-9\\\\.\\\\-\\\\_]*\\\\*?$"}},"kubernetesPodName":{"type":"array","minItems":1,"items":{"type":"string"}},"processExecutable":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^(?:\\\\/[^\\\\/\\\\*]+)*(?:\\\\/\\\\*|\\\\/\\\\*\\\\*)?$","minLength":1}},"processName":{"type":"array","minItems":1,"items":{"type":"string"}},"sessionLeaderInteractive":{"type":"boolean"}},"dependencies":{"containerImageFullName":{"not":{"required":["containerImageName"]}}}},"fileResponse":{"type":"object","required":["match","actions"],"additionalProperties":true,"properties":{"match":{"type":"array","minItems":1,"items":{"type":"string"}},"exclude":{"type":"array","items":{"type":"string"}},"actions":{"type":"array","minItems":1,"items":{"enum":["alert","block","log"]}}}},"processResponse":{"type":"object","required":["match","actions"],"additionalProperties":true,"properties":{"match":{"type":"array","minItems":1,"items":{"type":"string"}},"exclude":{"type":"array","items":{"type":"string"}},"actions":{"type":"array","minItems":1,"items":{"enum":["alert","block","log"]}}}}}}')},80:function(e,t,n){"use strict";n.r(t),n.d(t,"CloudDefendFleetPolicyReplaceDefineStepExtension",(function(){return $e})),n.d(t,"default",(function(){return $e}));var s=n(1),o=n.n(s),a=n(4),l=n(5),i=n(37),r=n(7);const c=r.i18n.translate("xpack.cloudDefend.name",{defaultMessage:"Name"}),u=r.i18n.translate("xpack.cloudDefend.description",{defaultMessage:"Description"}),d=r.i18n.translate("xpack.cloudDefend.enableControl",{defaultMessage:"Enable policy"}),p=r.i18n.translate("xpack.cloudDefend.enableControlHelp",{defaultMessage:"Enables drift prevention, alert, and logging policy shown below."}),b=r.i18n.translate("xpack.cloudDefend.controlGeneralView",{defaultMessage:"General view"}),m=r.i18n.translate("xpack.cloudDefend.controlYamlView",{defaultMessage:"YAML view"});var j=n(22);const g=r.i18n.translate("xpack.cloudDefend.fileSelector",{defaultMessage:"File selector"}),x=r.i18n.translate("xpack.cloudDefend.processSelector",{defaultMessage:"Process selector"}),f=r.i18n.translate("xpack.cloudDefend.networkSelector",{defaultMessage:"Network (coming soon)"}),y=r.i18n.translate("xpack.cloudDefend.fileResponse",{defaultMessage:"File response"}),O=r.i18n.translate("xpack.cloudDefend.processResponse",{defaultMessage:"Process response"}),h=r.i18n.translate("xpack.cloudDefend.networkResponse",{defaultMessage:"Network (coming soon)"}),k=r.i18n.translate("xpack.cloudDefend.conditions",{defaultMessage:"Conditions: "}),v=r.i18n.translate("xpack.cloudDefend.controlDuplicate",{defaultMessage:"Duplicate"}),E=r.i18n.translate("xpack.cloudDefend.controlRemove",{defaultMessage:"Remove"}),C=r.i18n.translate("xpack.cloudDefend.controlSelectors",{defaultMessage:"Selectors"}),I=r.i18n.translate("xpack.cloudDefend.controlSelectorsHelp",{defaultMessage:"Create file or process selectors to match on operations and or conditions of interest."}),M=r.i18n.translate("xpack.cloudDefend.controlResponses",{defaultMessage:"Responses"}),F=r.i18n.translate("xpack.cloudDefend.controlResponsesHelp",{defaultMessage:'Use responses to map one or more selectors to a set of actions. Selectors can also be used to "exclude" events.'}),S=r.i18n.translate("xpack.cloudDefend.controlMatchSelectors",{defaultMessage:"Match selectors"}),A=r.i18n.translate("xpack.cloudDefend.controlExcludeSelectors",{defaultMessage:"Exclude selectors"}),w=r.i18n.translate("xpack.cloudDefend.controlExclude",{defaultMessage:"Exclude"}),D=r.i18n.translate("xpack.cloudDefend.controlResponseActions",{defaultMessage:"Actions"}),T=r.i18n.translate("xpack.cloudDefend.controlResponseActionLog",{defaultMessage:"Log"}),N=r.i18n.translate("xpack.cloudDefend.controlResponseActionAlert",{defaultMessage:"Alert"}),z=r.i18n.translate("xpack.cloudDefend.controlResponseActionBlock",{defaultMessage:"Block"}),P=r.i18n.translate("xpack.cloudDefend.controlResponseActionBlockHelp",{defaultMessage:"Alert action must be enabled to block an event."}),R=(r.i18n.translate("xpack.cloudDefend.controlResponseActionAlertAndBlock",{defaultMessage:"Alert and block"}),r.i18n.translate("xpack.cloudDefend.addResponse",{defaultMessage:"Add response"})),q=r.i18n.translate("xpack.cloudDefend.addSelector",{defaultMessage:"Add selector"}),$=r.i18n.translate("xpack.cloudDefend.addSelectorCondition",{defaultMessage:"Add condition"}),B=r.i18n.translate("xpack.cloudDefend.name",{defaultMessage:"Name"}),V=r.i18n.translate("xpack.cloudDefend.unusedSelector",{defaultMessage:"Not in use"}),_=r.i18n.translate("xpack.cloudDefend.unusedSelectorHelp",{defaultMessage:"This selector is not in use by any response."}),L=r.i18n.translate("xpack.cloudDefend.errorInvalidTargetFilePath",{defaultMessage:'"Target file path" values must use absolute paths. A trailing * wildcard may be used to match all files in the target directory. Use double ** to match all files recursively. e.g /etc/**'}),J=r.i18n.translate("xpack.cloudDefend.errorInvalidProcessExecutable",{defaultMessage:'"Process executable" values must use absolute paths. A trailing * wildcard may be used to match all files in the target directory. Use double ** to match all files recursively. e.g /usr/bin/**'}),W=r.i18n.translate("xpack.cloudDefend.errorInvalidPodLabel",{defaultMessage:'Kubernetes pod label values must have the format: "key:value". A wildcard "*" can be used at the end of the value. e.g. "key:val*". To match on an empty label value, use "key:".'}),G=r.i18n.translate("xpack.cloudDefend.errorInvalidFullContainerImageName",{defaultMessage:'"Full container image name" values must be in the format: image_repo/image_name e.g. "docker.io/nginx"'}),H=r.i18n.translate("xpack.cloudDefend.errorConditionRequired",{defaultMessage:"At least one condition per selector is required."}),Z=r.i18n.translate("xpack.cloudDefend.errorDuplicateName",{defaultMessage:"This name is already used by another selector."}),U=r.i18n.translate("xpack.cloudDefend.errorInvalidName",{defaultMessage:"Selector names must be alphanumeric and contain no spaces."}),Y=r.i18n.translate("xpack.cloudDefend.errorValueRequired",{defaultMessage:"At least one value is required."}),K=r.i18n.translate("xpack.cloudDefend.errorActionRequired",{defaultMessage:"At least one action is required."}),Q=r.i18n.translate("xpack.cloudDefend.errorBlockActionRequiresTargetFilePath",{defaultMessage:'The "block" action requires targetFilePath be included in all "match" selectors using FIM operations or in at least one "exclude" selector. Note that selectors without operation will match on all operations, including createFile, modifyFile or deleteFile'}),X=r.i18n.translate("xpack.cloudDefend.warningFIMUsingSlashStarStarTitle",{defaultMessage:"Warning: Blocking FIM operations"}),ee=r.i18n.translate("xpack.cloudDefend.warningFIMUsingSlashStarStarText",{defaultMessage:"It is dangerous to block FIM operations using a targetFilePath of /**. This can lead to system instability. Note that selectors without operation will match on all operations, including createFile, modifyFile or deleteFile"}),te={containerImageFullName:{type:"stringArray",pattern:"^(?:\\[[a-fA-F0-9:]+\\]|(?:[a-zA-Z0-9-](?:\\.[a-z0-9]+)*)+)(?::[0-9]+)?(?:\\/[a-z0-9]+(?:[._-][a-z0-9]+)*)+$",patternError:G,not:["containerImageName"]},containerImageName:{type:"stringArray",pattern:"^([a-z0-9]+(?:[._-][a-z0-9]+)*)$",not:["containerImageFullName"]},containerImageTag:{type:"stringArray"},kubernetesClusterId:{type:"stringArray"},kubernetesClusterName:{type:"stringArray"},kubernetesNamespace:{type:"stringArray"},kubernetesPodName:{type:"stringArray"},kubernetesPodLabel:{type:"stringArray",pattern:"^([a-zA-Z0-9\\.\\-]+\\/)?[a-zA-Z0-9\\.\\-]+:[a-zA-Z0-9\\.\\-\\_]*\\*?$",patternError:W},operation:{type:"stringArray",values:{file:["createExecutable","modifyExecutable","createFile","modifyFile","deleteFile"],process:["fork","exec"]}},targetFilePath:{selectorType:"file",type:"stringArray",maxValueBytes:255,pattern:"^(?:\\/[^\\/\\*]+)*(?:\\/\\*|\\/\\*\\*)?$",patternError:L},ignoreVolumeFiles:{selectorType:"file",type:"flag",not:["ignoreVolumeMounts"]},ignoreVolumeMounts:{selectorType:"file",type:"flag",not:["ignoreVolumeFiles"]},processExecutable:{selectorType:"process",type:"stringArray",not:["processName"],pattern:"^(?:\\/[^\\/\\*]+)*(?:\\/\\*|\\/\\*\\*)?$",patternError:J},processName:{selectorType:"process",type:"stringArray",not:["processExecutable"],maxValueBytes:15},sessionLeaderInteractive:{selectorType:"process",type:"boolean"}},ne={type:"file",name:"Untitled",operation:["createExecutable","modifyExecutable"]},se={type:"process",name:"Untitled",operation:["fork","exec"]},oe={type:"file",match:[],actions:["alert"]},ae={type:"process",match:[],actions:["alert"]};var le=n(40);function ie(e){return"process"===e?"gear":"document"}function re(e){const t=e.replace(/([A-Z])/g," $1").toLowerCase();return t[0].toUpperCase()+t.slice(1)}function ce(e,t){const n={process:0,file:0};return e.forEach((e=>{n[e.type]++})),t.forEach((e=>{n[e.type]++})),n}function ue(e){return e&&(!e.operation||0===e.operation.length||e.operation.some((e=>le.b.indexOf(e)>=0)))}function de(e,t,n,s){return!(!n||!n.reduce(((n,o)=>{const a=e.find((e=>e.name===o)),l=!ue(a)||!(!a||!t.reduce(((e,t)=>e&&a.hasOwnProperty(t)),!0));return s?n&&l:n||l}),s))}function pe(e,t){const n=[];return t.forEach((t=>{var s;if(null!==(s=t.actions)&&void 0!==s&&s.includes("block")){const s=de(e,["targetFilePath"],t.exclude);de(e,["targetFilePath"],t.match,!0)||s||n.push(Q)}})),n}function be(e,t){const n=[],s=te[e].maxValueBytes||le.d,{pattern:o,patternError:a}=te[e];return null==t||t.forEach((t=>{0===(null==t?void 0:t.length)?n.push(r.i18n.translate("xpack.cloudDefend.errorGenericEmptyValue",{defaultMessage:'"{condition}" values cannot be empty',values:{condition:e}})):o&&!new RegExp(o).test(t)&&(a?n.push(a):n.push(r.i18n.translate("xpack.cloudDefend.errorGenericRegexFailure",{defaultMessage:'"{condition}" values must match the pattern: /{pattern}/',values:{condition:e,pattern:o}}))),new Blob([t]).size>s&&n.push(r.i18n.translate("xpack.cloudDefend.errorMaxValueBytesExceeded",{defaultMessage:'"{condition}" values cannot exceed {maxValueBytes} bytes',values:{condition:e,maxValueBytes:s}}))})),Object(j.uniq)(n)}const me=()=>{const{euiTheme:e}=Object(a.useEuiTheme)(),{size:t,border:n}=e;return Object(s.useMemo)((()=>({accordion:{borderRadius:n.radius.medium,border:n.thin,"> .euiAccordion__triggerWrapper":{padding:t.m}},conditionsBadge:{display:"inline"},verticalDivider:{display:"inline-block",verticalAlign:"middle",width:"1px",height:"20px",border:n.thin,borderRight:0,borderTop:0,borderBottom:0,marginLeft:t.base,marginRight:t.base}})),[n.radius.medium,n.thin,t.base,t.m])};var je=n(0);const ge=({label:e,prop:t,selector:n,onChangeBooleanCondition:o,onRemoveCondition:l})=>{const i=n[t],r=Object(s.useCallback)((e=>{o(t,e.target.checked)}),[o,t]);return Object(je.jsx)(a.EuiFormRow,{label:e,fullWidth:!0,key:t},Object(je.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiCheckbox,{id:t,label:e,checked:i,onChange:r})),Object(je.jsx)(a.EuiFlexItem,{grow:!1},Object(je.jsx)(a.EuiButtonIcon,{iconType:"cross",onClick:()=>l(t),"aria-label":"Remove condition","data-test-subj":"cloud-defend-btnremovecondition-"+t}))))},xe=({label:e,prop:t,onRemoveCondition:n})=>Object(je.jsx)(a.EuiFormRow,{label:e,fullWidth:!0,key:t},Object(je.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiText,{size:"s"},Object(je.jsx)("p",null,Object(je.jsx)("small",null,(e=>{switch(e){case"ignoreVolumeMounts":return r.i18n.translate("xpack.cloudDefend.ignoreVolumeMountsHelp",{defaultMessage:"Ignore operations on all volume mounts."});case"ignoreVolumeFiles":return r.i18n.translate("xpack.cloudDefend.ignoreVolumeFilesHelp",{defaultMessage:"Ignore operations on file mounts only. e.g mounted files, configMaps, secrets etc..."});default:return""}})(t))))),Object(je.jsx)(a.EuiFlexItem,{grow:!1},Object(je.jsx)(a.EuiButtonIcon,{iconType:"cross",onClick:()=>n(t),"aria-label":"Remove condition","data-test-subj":"cloud-defend-btnremovecondition-"+t})))),fe=({label:e,prop:t,selector:n,errorMap:s,onRemoveCondition:o,onAddValueToCondition:l,onChangeStringArrayCondition:i})=>{const r=n[t],c=(null==r?void 0:r.map((e=>({label:e,value:e}))))||[],u=function(e,t){var n;const s=te[t];return Array.isArray(s.values)?s.values:null!=s&&null!==(n=s.values)&&void 0!==n&&n[e]?s.values[e]:void 0}(n.type,t);return Object(je.jsx)(a.EuiFormRow,{label:e,fullWidth:!0,key:t,isInvalid:!!s.hasOwnProperty(t)},Object(je.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiComboBox,{"aria-label":e,fullWidth:!0,onCreateOption:u?void 0:e=>l(t,e),selectedOptions:c,options:u?u.map((e=>({label:e,value:e}))):c,onChange:e=>i(t,e.map((e=>e.value))),isClearable:!0,"data-test-subj":"cloud-defend-selectorcondition-"+t})),Object(je.jsx)(a.EuiFlexItem,{grow:!1},Object(je.jsx)(a.EuiButtonIcon,{iconType:"cross",onClick:()=>o(t),"aria-label":"Remove condition","data-test-subj":"cloud-defend-btnremovecondition-"+t}))))},ye=({selector:e,selectors:t,usedByResponse:n,index:l,onRemove:i,onDuplicate:c,onChange:u})=>{const[d,p]=Object(s.useState)(t.length-1===l?"open":"closed"),[b,m]=Object(s.useState)(!1),[j,g]=Object(s.useState)(!1),[x,f]=Object(s.useState)({}),y=me(),O=Object(s.useCallback)((()=>{m(!b)}),[b]),h=Object(s.useCallback)((()=>{m(!1)}),[]),C=Object(s.useCallback)((()=>{g(!j)}),[j]),I=Object(s.useCallback)((()=>{g(!1)}),[]),M=Object(s.useMemo)((()=>{return t=e.type,Object.keys(te).filter((e=>{const n=te[e];return!n.selectorType||n.selectorType===t}));var t}),[e]),F=Object(s.useMemo)((()=>M.filter((t=>!e.hasOwnProperty(t)))),[M,e]),S=Object(s.useMemo)((()=>Object.keys(e).filter((e=>!["type","hasErrors","name"].includes(e)))),[e]),A=Object(s.useCallback)((()=>{t.length>1&&i(l),h()}),[h,l,i,t.length]),w=Object(s.useCallback)((()=>{c(e),h()}),[h,c,e]),D=Object(s.useCallback)((n=>{const s=[],o=n.currentTarget.value;t.find((e=>e.name===o))&&s.push(Z),le.g.test(o)||s.push(U),s.length?x.name=s:delete x.name,f({...x});const a={...e};a.name=o,a.hasErrors=Object.keys(x).length>0||0===S.length,u(a,l)}),[x,l,S,u,e,t]),T=Object(s.useCallback)(((t,n)=>{const s={...e,[t]:n},o=[];0===n.length&&o.push(Y);const a=be(t,n);a.length>0&&o.push(...a),o.length?x[t]=o:delete x[t],s.hasErrors=Object.keys(x).length>0||0===S.length,f({...x}),u(s,l)}),[x,l,S,u,e]),N=Object(s.useCallback)(((t,n)=>{const s={...e,[t]:n};u(s,l)}),[l,u,e]),z=Object(s.useCallback)((e=>{const t=te[e].type;"flag"===t||"boolean"===t?N(e,!0):T(e,[]),I()}),[I,N,T]),P=Object(s.useCallback)((t=>{const n={...e};delete n[t],delete x[t],f({...x}),n.hasErrors=Object.keys(x).length>0||1===S.length,u(n,l),I()}),[I,S,x,l,u,e]),R=Object(s.useCallback)(((t,n)=>{const s=n.trim(),o=e[t];o&&-1===o.indexOf(s)&&T(t,[...o,s])}),[T,e]),q=Object(s.useMemo)((()=>{const e=Object.keys(x).reduce(((e,t)=>e.concat(x[t])),[]);return 0===S.length&&e.push(H),e}),[x,S]),L=Object(s.useCallback)((e=>{p(e?"open":"closed")}),[]);return Object(je.jsx)(a.EuiAccordion,{id:e.name,forceState:d,onToggle:L,"data-test-subj":"cloud-defend-selector",paddingSize:"m",buttonContent:Object(je.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiToolTip,{content:(J=e.type,"process"===J?r.i18n.translate("xpack.cloudDefend.processSelectorIconTooltip",{defaultMessage:"A process selector. Matches only on process operations."}):r.i18n.translate("xpack.cloudDefend.fileSelectorIconTooltip",{defaultMessage:"A file selector. Matches only on file operations."}))},Object(je.jsx)(a.EuiIcon,{color:"primary",type:ie(e.type)}))),Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiText,{size:"s"},Object(je.jsx)("b",null,e.name)))),css:y.accordion,extraAction:Object(je.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"none"},Object(je.jsx)("div",null,"closed"===d&&Object(je.jsx)(o.a.Fragment,null,Object(je.jsx)(a.EuiText,{css:y.conditionsBadge,size:"xs"},Object(je.jsx)("b",null,k)),Object(je.jsx)(a.EuiBadge,{title:S.join(","),color:"hollow","data-test-subj":"cloud-defend-conditions-count"},S.length)),!n&&Object(je.jsx)(a.EuiBadge,{title:_,color:"warning"},V),Object(je.jsx)("div",{css:y.verticalDivider})),Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiPopover,{id:e.name,button:Object(je.jsx)(a.EuiButtonIcon,{iconType:"boxesHorizontal",onClick:O,"aria-label":"Selector options","data-test-subj":"cloud-defend-btnselectorpopover"}),isOpen:b,closePopover:h,panelPaddingSize:"none",anchorPosition:"downLeft"},Object(je.jsx)(a.EuiContextMenuPanel,{size:"s",items:[Object(je.jsx)(a.EuiContextMenuItem,{key:"duplicate",icon:"copy",onClick:w,"data-test-subj":"cloud-defend-btnduplicateselector"},v),Object(je.jsx)(a.EuiContextMenuItem,{key:"remove",icon:"trash",disabled:t.length<2,onClick:A,"data-test-subj":"cloud-defend-btndeleteselector"},E)]}))))},Object(je.jsx)(a.EuiForm,{component:"form",error:q,isInvalid:q.length>0},Object(je.jsx)(a.EuiFormRow,{label:B,fullWidth:!0,isInvalid:!!x.hasOwnProperty("name")},Object(je.jsx)(a.EuiFieldText,{fullWidth:!0,name:"name",value:e.name,onChange:D,isInvalid:x.hasOwnProperty("name"),"data-test-subj":"cloud-defend-selectorcondition-name",maxLength:le.f})),S.map((t=>{const n=re(t),s=te[t].type;return"flag"===s?Object(je.jsx)(xe,{key:t,label:n,prop:t,onRemoveCondition:P}):"boolean"===s?Object(je.jsx)(ge,{key:t,label:n,selector:e,prop:t,onChangeBooleanCondition:N,onRemoveCondition:P}):Object(je.jsx)(fe,{key:t,label:n,prop:t,selector:e,errorMap:x,onAddValueToCondition:R,onChangeStringArrayCondition:T,onRemoveCondition:P})}))),Object(je.jsx)(a.EuiSpacer,{size:"m"}),Object(je.jsx)(a.EuiPopover,{id:"cloudDefendControlAddCondition","data-test-subj":"cloud-defend-addconditionpopover",button:Object(je.jsx)(a.EuiButtonEmpty,{onClick:C,iconType:"plusInCircle","data-test-subj":"cloud-defend-btnaddselectorcondition"},$),isOpen:j,closePopover:I,panelPaddingSize:"none",anchorPosition:"downLeft"},Object(je.jsx)(a.EuiContextMenuPanel,{size:"s",items:F.map((e=>{const t=re(e),n=function(e,t){const n=te[t];return!!e.find((e=>{var t;return null==n||null===(t=n.not)||void 0===t?void 0:t.includes(e)}))}(S,e);return Object(je.jsx)(a.EuiContextMenuItem,{"data-test-subj":`cloud-defend-addmenu-${e}`,key:e,onClick:()=>z(e),disabled:n},t)}))})));var J},Oe=/response_\d+_(.*)/,he=({response:e,selectors:t,responses:n,index:l,onRemove:i,onDuplicate:c,onChange:u})=>{var d,p,b,m,j;const{euiTheme:{colors:g}}=Object(a.useEuiTheme)(),[x,f]=Object(s.useState)(!1),y=(()=>{const{euiTheme:e}=Object(a.useEuiTheme)(),{border:t,size:n}=e,o=Object(a.useEuiBackgroundColor)("subdued");return Object(s.useMemo)((()=>({options:{position:"absolute",top:n.m,right:n.m},accordion:{borderRadius:t.radius.medium,"> .euiAccordion__triggerWrapper":{padding:n.m},backgroundColor:o},accordionHeader:{"> *":{display:"inline-block",verticalAlign:"middle"},"> b":{marginRight:n.s}}})),[o,t.radius.medium,n.m,n.s])})(),O=me(),h=Object(a.euiPaletteColorBlindBehindText)(),[k,C]=Object(s.useState)(n.length-1===l?"open":"closed"),I=null===(d=e.actions)||void 0===d?void 0:d.includes("log"),M=null===(p=e.actions)||void 0===p?void 0:p.includes("alert"),F=null===(b=e.actions)||void 0===b?void 0:b.includes("block"),R=Object(s.useMemo)((()=>F&&function(e,t){return!(!t||!t.reduce(((t,n)=>{var s;const o=e.find((e=>e.name===n)),a=ue(o);return t||!(!a||null==o||null===(s=o.targetFilePath)||void 0===s||!s.includes("/**"))}),!1))}(t,e.match)),[F,e.match,t]),q=Object(s.useMemo)((()=>{var n;const s={};if(0===e.match.length&&(s.match=[Y]),0===(null===(n=e.actions)||void 0===n?void 0:n.length)&&(s.actions=[K]),F){const n=pe(t,[e]);n.length>0&&(s.response=n)}return s}),[e,t,F]),$=Object(s.useMemo)((()=>Object.values(q)),[q]),B=Object(s.useCallback)(((e,t)=>{$.length&&(e.hasErrors=!0),u(e,t)}),[$.length,u]);Object(s.useEffect)((()=>{const t=$.length>0;(t&&!e.hasErrors||!t&&e.hasErrors)&&(e.hasErrors=t,u(e,l))}),[$.length,l,u,e]);const V=Object(s.useCallback)((()=>{f(!x)}),[x]),_=Object(s.useCallback)((()=>{f(!1)}),[]),L=Object(s.useCallback)((()=>{i(l),_()}),[_,l,i]),J=Object(s.useCallback)((()=>{c(e),_()}),[_,c,e]),W=Object(s.useCallback)((t=>{e.match=t.map((e=>e.value)),B(e,l)}),[l,B,e]),G=Object(s.useCallback)((t=>{var n;e.exclude=t.map((e=>e.value)),0===(null===(n=e.exclude)||void 0===n?void 0:n.length)&&delete e.exclude,B(e,l)}),[l,B,e]),H=Object(s.useMemo)((()=>t.filter((t=>{var n;return!(t.type!==e.type||e.match.includes(t.name)||null!==(n=e.exclude)&&void 0!==n&&n.includes(t.name))})).map((e=>({label:e.name,value:e.name})))),[e.exclude,e.match,e.type,t]),Z=Object(s.useMemo)((()=>e.match.map((e=>({label:e,value:e,color:h[0]})))),[e.match,h]),U=Object(s.useMemo)((()=>e.exclude&&e.exclude.map((e=>({label:e,value:e,color:h[5]})))),[e.exclude,h]),Q=Object(s.useCallback)((()=>{const t={...e};t.exclude=[],B(t,l)}),[l,B,e]),te=Object(s.useCallback)((t=>{var n,s,o;const a=null===(n=t.currentTarget)||void 0===n||null===(s=n.id)||void 0===s||null===(o=s.match(Oe))||void 0===o?void 0:o[1],i=JSON.parse(JSON.stringify(e)),r=i.actions.indexOf(a);if(-1===r)i.actions.push(a);else{if("alert"===a){const e=i.actions.indexOf("block");-1!==e&&i.actions.splice(e,1)}i.actions.splice(r,1)}B(i,l)}),[l,B,e]),ne=Object(s.useCallback)((e=>{C(e?"open":"closed")}),[]),{title:se,plusCount:oe,remainingNames:ae}=Object(s.useMemo)((()=>"open"===k?{title:e.match.slice(0,4).join(", "),plusCount:e.match.length-4,remainingNames:e.match.slice(4).join(",")}:{title:e.match.slice(0,2).join(", "),plusCount:e.match.length-2,remainingNames:e.match.slice(2).join(",")}),[k,e.match]);return Object(je.jsx)(a.EuiAccordion,{id:"response_"+l,forceState:k,onToggle:ne,"data-test-subj":`cloud-defend-${e.type}-response`,paddingSize:"m",buttonContent:Object(je.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},Object(je.jsx)(a.EuiFlexItem,{grow:!1},Object(je.jsx)(a.EuiToolTip,{content:(le=e.type,"process"===le?r.i18n.translate("xpack.cloudDefend.processResponseIconTooltip",{defaultMessage:"A process response.\nOnly process selectors can be used to match/exclude."}):r.i18n.translate("xpack.cloudDefend.fileResponseIconTooltip",{defaultMessage:"A file response.\nOnly file selectors can be used to match/exclude."}))},Object(je.jsx)(a.EuiIcon,{color:"primary",type:ie(e.type)}))),Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiText,{size:"s",css:y.accordionHeader},Object(je.jsx)("b",null,se),oe>0&&Object(je.jsx)(a.EuiBadge,{title:ae},"+",oe)))),css:y.accordion,initialIsOpen:0===l,extraAction:Object(je.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"none",wrap:!1},"closed"===k&&Object(je.jsx)(a.EuiText,{color:"subdued",css:O.conditionsBadge,size:"xs"},(null==e||null===(m=e.exclude)||void 0===m?void 0:m.length)&&Object(je.jsx)(o.a.Fragment,null,Object(je.jsx)("b",null,w,": "),Object(je.jsx)(a.EuiBadge,{title:e.exclude.join(","),color:"hollow"},e.exclude.length),Object(je.jsx)("div",{css:O.verticalDivider})),Object(je.jsx)("b",null,D,": "),null===(j=e.actions)||void 0===j?void 0:j.map(((t,n)=>{var s;return Object(je.jsx)("span",{key:t},Object(je.jsx)("b",{style:{color:"block"===t?g.danger:g.ink}},t[0].toUpperCase()+t.slice(1)),n!==((null===(s=e.actions)||void 0===s?void 0:s.length)||0)-1&&", ")})),Object(je.jsx)("div",{css:O.verticalDivider})),Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiPopover,{button:Object(je.jsx)(a.EuiButtonIcon,{iconType:"boxesHorizontal",onClick:V,"aria-label":"Response options","data-test-subj":"cloud-defend-btnresponsepopover"}),isOpen:x,closePopover:_,panelPaddingSize:"none",anchorPosition:"downLeft"},Object(je.jsx)(a.EuiContextMenuPanel,{size:"s",items:[Object(je.jsx)(a.EuiContextMenuItem,{key:"duplicate",icon:"copy",onClick:J,"data-test-subj":"cloud-defend-btnduplicateresponse"},v),Object(je.jsx)(a.EuiContextMenuItem,{key:"remove",icon:"trash",disabled:n.length<2,onClick:L,"data-test-subj":"cloud-defend-btndeleteresponse"},E)]}))))},Object(je.jsx)(a.EuiForm,{component:"form",fullWidth:!0,error:$,isInvalid:$.length>0},R&&Object(je.jsx)(a.EuiFormRow,{fullWidth:!0},Object(je.jsx)(a.EuiCallOut,{color:"warning",title:X},Object(je.jsx)("p",null,ee))),Object(je.jsx)(a.EuiFormRow,{label:S,fullWidth:!0,isInvalid:!!q.match},Object(je.jsx)(a.EuiComboBox,{"aria-label":S,fullWidth:!0,selectedOptions:Z,options:H,isClearable:!0,onChange:W,"data-test-subj":"cloud-defend-responsematch"})),e.exclude&&Object(je.jsx)(a.EuiFormRow,{label:A,fullWidth:!0},Object(je.jsx)(a.EuiComboBox,{"aria-label":A,fullWidth:!0,selectedOptions:U,options:H,onChange:G,isClearable:!0,"data-test-subj":"cloud-defend-responseexclude"})),Object(je.jsx)(a.EuiSpacer,{size:"s"}),!e.exclude&&Object(je.jsx)(a.EuiButtonEmpty,{iconType:"plusInCircle",onClick:Q,size:"xs","data-test-subj":"cloud-defend-btnshowexclude"},A),Object(je.jsx)(a.EuiSpacer,{size:"m"}),Object(je.jsx)(a.EuiFormRow,{label:D,fullWidth:!0,isInvalid:!!q.actions},Object(je.jsx)(a.EuiFlexGroup,{direction:"row",gutterSize:"l"},Object(je.jsx)(a.EuiFlexItem,{grow:!1},Object(je.jsx)(a.EuiCheckbox,{id:`response_${l}_log`,"data-test-subj":"cloud-defend-chklogaction",label:T,checked:I,onChange:te})),Object(je.jsx)(a.EuiFlexItem,{grow:!1},Object(je.jsx)(a.EuiCheckbox,{id:`response_${l}_alert`,"data-test-subj":"cloud-defend-chkalertaction",label:N,checked:M,onChange:te})),Object(je.jsx)(a.EuiFlexItem,{grow:!1},Object(je.jsx)(a.EuiToolTip,{content:P},Object(je.jsx)(a.EuiCheckbox,{id:`response_${l}_block`,"data-test-subj":"cloud-defend-chkblockaction",label:z,checked:F,onChange:te,disabled:!M})))))));var le},ke=({type:e,onSelectType:t,selectors:n,responses:o})=>{const l=Object(s.useMemo)((()=>ce(n,o)),[o,n]),[i,r]=Object(s.useState)(!1),c=()=>{r(!1)},u=Object(s.useCallback)((()=>{c(),t("file")}),[t]),d=Object(s.useCallback)((()=>{c(),t("process")}),[t]),p="Selector"===e,b=[Object(je.jsx)(a.EuiContextMenuItem,{key:`addFile${e}`,icon:"document",onClick:u,disabled:l.file>=le.e,"data-test-subj":`cloud-defend-btnAddFile${e}`},p?g:y),Object(je.jsx)(a.EuiContextMenuItem,{key:`addProcess${e}`,icon:"gear",onClick:d,disabled:l.process>=le.e,"data-test-subj":`cloud-defend-btnAddProcess${e}`},p?x:O),Object(je.jsx)(a.EuiContextMenuItem,{key:`addNetwork${e}`,icon:"globe",disabled:!0,"data-test-subj":`cloud-defend-btnAddNetwork${e}`},p?f:h)];return Object(je.jsx)(a.EuiPopover,{id:`btnAdd${e}`,display:"block",button:Object(je.jsx)(a.EuiButton,{fullWidth:!0,color:"primary",iconType:"plusInCircle",onClick:()=>{r(!i)},"data-test-subj":`cloud-defend-btnAdd${e}`},p?q:R),isOpen:i,closePopover:c,panelPaddingSize:"none",anchorPosition:"downLeft"},Object(je.jsx)(a.EuiContextMenuPanel,{size:"s",items:b}))},ve=({policy:e,onChange:t,show:n})=>{var o,r,c;const u=Object(s.useMemo)((()=>({panel:{position:"relative"},draggable:{padding:0,paddingBottom:"12px"},hide:{display:"none"}})),[]),d=Object(i.b)(e,l.b),p=(null==d||null===(o=d.vars)||void 0===o||null===(r=o.configuration)||void 0===r?void 0:r.value)||"",{selectors:b,responses:m}=Object(s.useMemo)((()=>Object(i.c)(p)),[p]),j=Object(s.useCallback)(((n,s)=>{var o;if(null!=d&&null!==(o=d.vars)&&void 0!==o&&o.configuration){const o=!n.find((e=>e.hasErrors))&&!s.find((e=>e.hasErrors));d.vars.configuration.value=Object(i.d)(n,s),t({isValid:o,updatedPolicy:{...e}})}}),[null==d||null===(c=d.vars)||void 0===c?void 0:c.configuration,t,e]),g=Object(s.useCallback)((e=>{const t=e.search(/\d+$/),n=-1!==t?e.slice(0,t)+(parseInt(e.slice(t),10)+1):e+"1",s=b.find((e=>e.name===n));return s?g(s.name):n}),[b]),x=Object(s.useCallback)((e=>{const t=function(e){return"process"===e?JSON.parse(JSON.stringify(se)):JSON.parse(JSON.stringify(ne))}(e),n=b.find((e=>e.name===t.name));n&&(t.name=g(n.name)),b.push(t),j(b,m)}),[g,j,m,b]),f=Object(s.useCallback)((e=>{const t=function(e){return"process"===e?{...ae}:{...oe}}(e);m.push(t),j(b,m)}),[j,m,b]),y=Object(s.useCallback)((e=>{const t=JSON.parse(JSON.stringify(e));t.name=g(t.name),b.push(t),j(b,m)}),[g,j,m,b]),O=Object(s.useCallback)((e=>{const t=b[e].name,n=[...b];n.splice(e,1);const s=m.map((e=>{const n={...e},s=n.match.indexOf(t);if(-1!==s&&n.match.splice(s,1),n.exclude){const e=n.exclude.indexOf(t);-1!==e&&n.exclude.splice(e,1)}return n}));j(n,s)}),[j,m,b]),h=Object(s.useCallback)((e=>{const t={...e};m.push(t),j(b,m)}),[j,m,b]),k=Object(s.useCallback)((e=>{const t=[...m];t.splice(e,1),j(b,t)}),[j,m,b]),v=Object(s.useCallback)(((e,t)=>{const n=b[t];!1===e.hasErrors&&delete e.hasErrors;const s=JSON.parse(JSON.stringify(b));let o=JSON.parse(JSON.stringify(m));n.name!==e.name&&(o=m.map((t=>{let s=t.match.indexOf(n.name);return-1!==s&&(t.match[s]=e.name),t.exclude&&(s=t.exclude.indexOf(n.name),-1!==s&&(t.exclude[s]=e.name)),t}))),s[t]=JSON.parse(JSON.stringify(e)),j(s,o)}),[j,m,b]),E=Object(s.useCallback)(((e,t)=>{!1===e.hasErrors&&delete e.hasErrors;const n=JSON.parse(JSON.stringify(m));n[t]=JSON.parse(JSON.stringify(e)),j(b,n)}),[j,m,b]);return Object(je.jsx)(a.EuiFlexGroup,{css:!n&&u.hide,gutterSize:"m",direction:"column","data-test-subj":"cloud-defend-generalview"},Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiTitle,{size:"xs"},Object(je.jsx)("h4",null,C)),Object(je.jsx)(a.EuiText,{color:"subdued",size:"s"},I)),b.map(((e,t)=>{const n=!!m.find((t=>{var n;return t.match.includes(e.name)||(null==t||null===(n=t.exclude)||void 0===n?void 0:n.includes(e.name))}));return Object(je.jsx)(a.EuiFlexItem,{key:t},Object(je.jsx)(ye,{key:t,index:t,selector:e,selectors:b,usedByResponse:n,onDuplicate:y,onRemove:O,onChange:v}))})),Object(je.jsx)(ke,{type:"Selector",onSelectType:x,selectors:b,responses:m}),Object(je.jsx)(a.EuiSpacer,{size:"m"}),Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiTitle,{size:"xs"},Object(je.jsx)("h4",null,M)),Object(je.jsx)(a.EuiText,{size:"s",color:"subdued"},F)),m.map(((e,t)=>Object(je.jsx)(a.EuiFlexItem,{key:t},Object(je.jsx)(he,{index:t,response:e,responses:m,selectors:b,onRemove:k,onDuplicate:h,onChange:E})))),Object(je.jsx)(ke,{type:"Response",onSelectType:f,selectors:b,responses:m}),Object(je.jsx)(a.EuiSpacer,{size:"m"}))};var Ee=n(27),Ce=n(26),Ie=n(70);const{Uri:Me,editor:Fe}=Ce.monaco,Se="http://elastic.co/cloud_defend.json",Ae=Me.parse(Se),we=r.i18n.translate("xpack.cloudDefend.alertActionRequired",{defaultMessage:'The alert action is required when "block" action used.'}),De=r.i18n.translate("xpack.cloudDefend.controlYamlHelp",{defaultMessage:'Configure your policy by creating "file" or "process" selectors and responses below.'}),{editor:Te}=Ce.monaco,Ne=({policy:e,onChange:t,show:n})=>{var o,c;const u=(()=>{const{euiTheme:e}=Object(a.useEuiTheme)(),{border:t}=e;return Object(s.useMemo)((()=>({yamlEditor:{height:"500px",border:t.thin},hide:{visibility:"hidden",position:"absolute"}})),[t.thin])})(),[d,p]=Object(s.useState)([]),[b,m]=Object(s.useState)([]),g=Object(i.b)(e,l.b),x=(null==g||null===(o=g.vars)||void 0===o||null===(c=o.configuration)||void 0===c?void 0:c.value)||"",f=(e=>{const[t,n]=Object(s.useState)(null),o=Object(s.useMemo)((()=>{const t={...Ie},{selectors:n}=Object(i.c)(e);if(t.$defs.fileResponse.properties.match.items){const e=t.$defs.fileResponse.properties,s={enum:n.filter((e=>"file"===e.type)).map((e=>e.name))};e.match.items=s,e.exclude.items=s}if(t.$defs.processResponse.properties.match.items){const e=t.$defs.processResponse.properties,s={enum:n.filter((e=>"process"===e.type)).map((e=>e.name))};e.match.items=s,e.exclude.items=s}return t}),[e]);return Object(s.useEffect)((()=>{!async function(...e){const{dispose:t}=await Object(Ce.configureMonacoYamlSchema)(...e);let s=Fe.getModel(Ae);null===s&&(s=Fe.createModel("",Ce.YAML_LANG_ID,Ae)),n(s)}([{uri:Se,fileMatch:[String(Ae)],schema:o}])}),[o]),t})(x),y=Object(s.useCallback)((e=>{const t=[],{selectors:n,responses:s}=Object(i.c)(e);return t.push(...function(e,t){const n=[],s=ce(e,t);return Object.values(s).forEach((e=>{e>le.e&&n.push(r.i18n.translate("xpack.cloudDefend.errorMaxSelectorsResponsesExceeded",{defaultMessage:"You cannot exceed {max} selectors + responses for a given type e.g file, process",values:{max:le.e}}))})),n}(n,s)),t.push(...pe(n,s)),n.forEach((e=>{Object.keys(e).map((n=>{var s;const o=n;if("stringArray"===(null===(s=te[o])||void 0===s?void 0:s.type)){const n=e[o];t.push(...be(o,n))}}))})),s.forEach((e=>{e.actions&&e.actions.includes("block")&&!e.actions.includes("alert")&&t.push(we)})),Object(j.uniq)(t)}),[]);Object(s.useEffect)((()=>{if(!n)return;const s=y(x);s.length!==b.length&&m(s);const o=Te.onDidChangeMarkers((([n])=>{const o=Te.getModelMarkers({resource:n}).map((e=>({line:e.startLineNumber,message:e.message})));s.length===b.length&&JSON.stringify(o)===JSON.stringify(d)||(t({isValid:0===s.length&&0===o.length,updatedPolicy:e}),p(o))}));return()=>{o.dispose()}}),[d,t,e,b.length,y,x,n]);const O=Object(s.useCallback)((s=>{if(n&&null!=g&&g.vars){g.vars.configuration.value=s;const n=y(s);m(n),t({isValid:0===n.length&&0===d.length,updatedPolicy:e})}}),[d.length,null==g?void 0:g.vars,t,e,n,y]);return Object(je.jsx)(a.EuiFlexGroup,{direction:"column",css:!n&&u.hide},Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiText,{color:"subdued",size:"s"},De),Object(je.jsx)(a.EuiSpacer,{size:"s"}),b.length>0&&Object(je.jsx)(a.EuiForm,{"data-test-subj":"cloudDefendAdditionalErrors",isInvalid:!0,error:b}),Object(je.jsx)("div",{css:u.yamlEditor},Object(je.jsx)(Ee.CodeEditor,{width:"100%",languageId:Ee.YamlLang,options:{wordWrap:"off",model:f,automaticLayout:!0,padding:{top:10,bottom:10}},onChange:O,value:x})),Object(je.jsx)(a.EuiSpacer,{size:"s"})))},ze="general",Pe="yaml",Re=({policy:e,onChange:t})=>{const[n,o]=Object(s.useState)(ze),[l,i]=Object(s.useState)(!0),r=Object(s.useCallback)((()=>{o(ze)}),[]),c=Object(s.useCallback)((()=>{o(Pe)}),[]),u=n===ze,d=n===Pe,p=Object(s.useCallback)((n=>{n.updatedPolicy=e,t(n),i(n.isValid)}),[t,e]),j=Object(s.useCallback)((n=>{n.updatedPolicy=e,t(n),i(n.isValid)}),[t,e]);return Object(je.jsx)(a.EuiFlexGroup,{direction:"column"},Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiTabs,null,Object(je.jsx)(a.EuiTab,{id:ze,onClick:r,isSelected:u,"data-test-subj":"cloud-defend-btngeneralview",disabled:!l},b),Object(je.jsx)(a.EuiTab,{id:Pe,onClick:c,isSelected:d,"data-test-subj":"cloud-defend-btnyamlview",disabled:!l},m))),Object(je.jsx)(a.EuiFlexItem,null,u&&Object(je.jsx)(ve,{show:u,policy:e,onChange:p}),Object(je.jsx)(Ne,{show:d,policy:e,onChange:j})))},qe=({policy:e,onChange:t})=>{const[n,o]=Object(s.useState)(!1),r=Object(i.b)(e,l.b),b=!(null==r||!r.enabled),m=Object(s.useCallback)((s=>{r&&(r.enabled=s.target.checked,t({isValid:!n,updatedPolicy:{...e}}))}),[r,t,n,e]),j=Object(s.useCallback)((s=>{const o=s.currentTarget.value;t({isValid:!n,updatedPolicy:{...e,name:o}})}),[t,n,e]),g=Object(s.useCallback)((s=>{const o=s.currentTarget.value;t({isValid:!n,updatedPolicy:{...e,description:o}})}),[t,n,e]),x=Object(s.useCallback)((e=>{o(!e.isValid),t(e)}),[t]);return Object(je.jsx)(a.EuiFlexGroup,{direction:"column"},Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiForm,{component:"form"},Object(je.jsx)(a.EuiFormRow,{label:c,fullWidth:!0},Object(je.jsx)(a.EuiFieldText,{fullWidth:!0,name:"name",value:e.name,onChange:j,"data-test-subj":"cloud-defend-policy-name"})),Object(je.jsx)(a.EuiFormRow,{label:u,fullWidth:!0},Object(je.jsx)(a.EuiTextArea,{fullWidth:!0,name:"name",value:e.description,onChange:g,"data-test-subj":"cloud-defend-policy-description",compressed:!0})),Object(je.jsx)(a.EuiHorizontalRule,null),Object(je.jsx)(a.EuiFormRow,{fullWidth:!0},Object(je.jsx)(a.EuiFlexItem,null,Object(je.jsx)(a.EuiSwitch,{"data-test-subj":"cloud-defend-controltoggle",label:d,checked:b,onChange:m}),Object(je.jsx)(a.EuiSpacer,{size:"s"}),Object(je.jsx)(a.EuiText,{color:"subdued",size:"s"},p))))),b&&Object(je.jsx)(Re,{"data-test-subj":"cloud-defend-controlsettings",policy:e,onChange:x}))},$e=Object(s.memo)((({newPolicy:e,onChange:t})=>{const n=JSON.parse(JSON.stringify(e));return Object(je.jsx)(qe,{policy:n,onChange:t})}));$e.displayName="CloudDefendFleetPolicyReplaceDefineStepExtension"}}]);