"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubscriptionNotAllowed = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../common/hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SubscriptionNotAllowed = () => {
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    color: "danger",
    alignment: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudDefend.subscriptionNotAllowed.promptTitle",
      defaultMessage: "Upgrade for subscription features"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudDefend.subscriptionNotAllowed.promptDescription",
      defaultMessage: "To use these cloud security features, you must {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: application.getUrlForApp('management', {
            path: 'stack/license_management/home'
          })
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.cloudDefend.subscriptionNotAllowed.promptLinkText",
          defaultMessage: "start a trial or upgrade your subscription"
        }))
      }
    }))
  }));
};
exports.SubscriptionNotAllowed = SubscriptionNotAllowed;