"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _control_general_view = require("../control_general_view");
var _control_yaml_view = require("../control_yaml_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VIEW_MODE_GENERAL = 'general';
const VIEW_MODE_YAML = 'yaml';
const ControlSettings = ({
  policy,
  onChange
}) => {
  const [viewMode, setViewMode] = (0, _react.useState)(VIEW_MODE_GENERAL);
  const [isValid, setIsValid] = (0, _react.useState)(true);
  const onViewModeGeneral = (0, _react.useCallback)(() => {
    setViewMode(VIEW_MODE_GENERAL);
  }, []);
  const onViewModeYaml = (0, _react.useCallback)(() => {
    setViewMode(VIEW_MODE_YAML);
  }, []);
  const isGeneralViewSelected = viewMode === VIEW_MODE_GENERAL;
  const isYamlViewSelected = viewMode === VIEW_MODE_YAML;
  const onGeneralChanges = (0, _react.useCallback)(opts => {
    opts.updatedPolicy = policy;
    onChange(opts);
    setIsValid(opts.isValid);
  }, [onChange, policy]);
  const onYamlChanges = (0, _react.useCallback)(opts => {
    opts.updatedPolicy = policy;
    onChange(opts);
    setIsValid(opts.isValid);
  }, [onChange, policy]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    id: VIEW_MODE_GENERAL,
    onClick: onViewModeGeneral,
    isSelected: isGeneralViewSelected,
    "data-test-subj": "cloud-defend-btngeneralview",
    disabled: !isValid
  }, i18n.viewModeGeneral), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    id: VIEW_MODE_YAML,
    onClick: onViewModeYaml,
    isSelected: isYamlViewSelected,
    "data-test-subj": "cloud-defend-btnyamlview",
    disabled: !isValid
  }, i18n.viewModeYaml))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isGeneralViewSelected && /*#__PURE__*/_react.default.createElement(_control_general_view.ControlGeneralView, {
    show: isGeneralViewSelected,
    policy: policy,
    onChange: onGeneralChanges
  }), /*#__PURE__*/_react.default.createElement(_control_yaml_view.ControlYamlView, {
    show: isYamlViewSelected,
    policy: policy,
    onChange: onYamlChanges
  })));
};
exports.ControlSettings = ControlSettings;