"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudChatPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _constants = require("../common/constants");
var _services = require("./services");
var _util = require("../common/util");
var _chat_experiment_switcher = require("./components/chat_experiment_switcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CloudChatPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "chatConfig$", new _rxjs.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "kbnVersion", void 0);
    (0, _defineProperty2.default)(this, "kbnBuildNum", void 0);
    this.kbnVersion = initializerContext.env.packageInfo.version;
    this.kbnBuildNum = initializerContext.env.packageInfo.buildNum;
    this.config = initializerContext.config.get();
    this.logger = initializerContext.logger.get();
  }
  setup(core, {
    cloud
  }) {
    this.setupChat({
      http: core.http,
      cloud
    }).catch(e => this.logger.debug(`Error setting up Chat: ${e.toString()}`));
  }
  start(core) {
    const CloudChatContextProvider = ({
      children
    }) => {
      // There's a risk that the request for chat config will take too much time to complete, and the provider
      // will maintain a stale value.  To avoid this, we'll use an Observable.
      const chatConfig = (0, _useObservable.default)(this.chatConfig$, undefined);
      return /*#__PURE__*/_react.default.createElement(_services.ServicesProvider, {
        chat: chatConfig
      }, children);
    };
    function ConnectedChat(props) {
      return /*#__PURE__*/_react.default.createElement(CloudChatContextProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(_chat_experiment_switcher.ChatExperimentSwitcher, {
        location$: core.application.currentLocation$,
        variant: props.chatVariant
      })));
    }
    this.chatConfig$.pipe((0, _rxjs.first)(config => config != null)).subscribe(config => {
      core.chrome.navControls.registerExtension({
        order: 50,
        mount: e => {
          _reactDom.default.render( /*#__PURE__*/_react.default.createElement(ConnectedChat, {
            chatVariant: config.chatVariant
          }), e);
          return () => {
            _reactDom.default.unmountComponentAtNode(e);
          };
        }
      });
    });
  }
  stop() {}
  async setupChat({
    cloud,
    http
  }) {
    const {
      isCloudEnabled,
      trialEndDate
    } = cloud;
    const {
      chatURL,
      trialBuffer
    } = this.config;
    if (!isCloudEnabled || !chatURL || !trialEndDate || !(0, _util.isTodayInDateWindow)(trialEndDate, trialBuffer)) {
      return;
    }
    try {
      const {
        email,
        id,
        token: jwt,
        chatVariant
      } = await http.get(_constants.GET_CHAT_USER_DATA_ROUTE_PATH);
      if (!email || !id || !jwt) {
        return;
      }
      this.chatConfig$.next({
        chatURL,
        chatVariant,
        user: {
          email,
          id,
          jwt,
          trialEndDate: trialEndDate,
          kbnVersion: this.kbnVersion,
          kbnBuildNum: this.kbnBuildNum
        }
      });
    } catch (e) {
      this.logger.debug(`[cloud.chat] Could not retrieve chat config: ${e.response.status} ${e.message}`, e);
    }
  }
}
exports.CloudChatPlugin = CloudChatPlugin;