"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chat = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _when_idle = require("./when_idle");
var _use_chat_config = require("./use_chat_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A component that will display a trigger that will allow the user to chat with a human operator,
 * when the service is enabled; otherwise, it renders nothing.
 */
const Chat = ({
  onReady,
  onResize,
  onPlaybookFired,
  topOffset = 0
}) => {
  const config = (0, _use_chat_config.useChatConfig)({
    onReady,
    onResize,
    onPlaybookFired
  });
  if (!config.enabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_when_idle.WhenIdle, null, /*#__PURE__*/_react.default.createElement("iframe", {
    "data-test-subj": "cloud-chat-frame",
    title: _i18n.i18n.translate('xpack.cloudChat.chatFrameTitle', {
      defaultMessage: 'Chat'
    }),
    src: config.src,
    ref: config.ref,
    style: config.isReady ? {
      position: 'fixed',
      ...config.style,
      // reset default button positioning
      bottom: 'auto',
      inset: 'initial',
      // force position to the top and of the page
      top: topOffset,
      right: 0,
      // TODO: if the page height is smaller than widget height + topOffset,
      // the widget will be cut off from the bottom.
      // @ts-ignore - fixes white background on iframe in chrome/system dark mode
      colorScheme: 'light'
    } : {
      display: 'none'
    }
  }));
};
exports.Chat = Chat;