"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPlaceholder = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const style = (0, _react2.css)`
  height: 100%;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
`;
const EmptyPlaceholder = ({
  icon,
  iconColor = 'subdued',
  message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "charts.noDataLabel",
    defaultMessage: "No results found"
  }),
  dataTestSubj = 'emptyPlaceholder',
  className,
  renderComplete
}) => {
  (0, _react.useEffect)(() => {
    renderComplete === null || renderComplete === void 0 ? void 0 : renderComplete();
  }, [renderComplete]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: className,
    css: style
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": dataTestSubj,
    textAlign: "center",
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    color: iconColor,
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("p", null, message)));
};
exports.EmptyPlaceholder = EmptyPlaceholder;