"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.casesConnectors = void 0;
var _domain = require("../../common/types/domain");
var _jira = require("./jira");
var _resilient = require("./resilient");
var _cases_webook = require("./cases_webook");
var _servicenow = require("./servicenow");
var _swimlane = require("./swimlane");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapping = {
  [_domain.ConnectorTypes.casesWebhook]: (0, _cases_webook.getCaseConnector)(),
  [_domain.ConnectorTypes.jira]: (0, _jira.getCaseConnector)(),
  [_domain.ConnectorTypes.serviceNowITSM]: (0, _servicenow.getServiceNowITSMCaseConnector)(),
  [_domain.ConnectorTypes.serviceNowSIR]: (0, _servicenow.getServiceNowSIRCaseConnector)(),
  [_domain.ConnectorTypes.resilient]: (0, _resilient.getCaseConnector)(),
  [_domain.ConnectorTypes.swimlane]: (0, _swimlane.getCaseConnector)(),
  [_domain.ConnectorTypes.none]: null
};
const isConnectorTypeSupported = type => Object.values(_domain.ConnectorTypes).includes(type);
const casesConnectors = exports.casesConnectors = {
  get: type => isConnectorTypeSupported(type) ? mapping[type] : undefined
};