"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesConnectorSecretsSchema = exports.CasesConnectorRunParamsSchema = exports.CasesConnectorRuleActionParamsSchema = exports.CasesConnectorParamsSchema = exports.CasesConnectorConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _constants = require("./constants");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
  validate: value => {
    if (!Object.hasOwn(value, '_id') || !Object.hasOwn(value, '_index')) {
      return 'Alert ID and index must be defined';
    }
  }
});

/**
 * At the moment only one field is supported for grouping
 */
const GroupingSchema = _configSchema.schema.arrayOf(_configSchema.schema.string(), {
  minSize: 0,
  maxSize: 1
});
const RuleSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  }),
  ruleUrl: _configSchema.schema.nullable(_configSchema.schema.string())
});
const ReopenClosedCasesSchema = _configSchema.schema.boolean({
  defaultValue: false
});
const TimeWindowSchema = _configSchema.schema.string({
  defaultValue: '7d',
  validate: value => {
    /**
     * Validates the time window.
     * Acceptable format:
     * - First character should be a digit from 1 to 9
     * - All next characters should be a digit from 0 to 9
     * - The last character should be d (day) or w (week)
     *
     * Example: 20d, 2w, etc
     */
    const timeWindowRegex = new RegExp(_constants2.CASES_CONNECTOR_TIME_WINDOW_REGEX, 'g');
    if (!timeWindowRegex.test(value)) {
      return 'Not a valid time window';
    }
    const date = _datemath.default.parse(`now-${value}`);
    if (!date || !date.isValid()) {
      return 'Not a valid time window';
    }
  }
});

/**
 * The case connector does not have any configuration
 * or secrets.
 */
const CasesConnectorConfigSchema = exports.CasesConnectorConfigSchema = _configSchema.schema.object({});
const CasesConnectorSecretsSchema = exports.CasesConnectorSecretsSchema = _configSchema.schema.object({});
const CasesConnectorRunParamsSchema = exports.CasesConnectorRunParamsSchema = _configSchema.schema.object({
  alerts: _configSchema.schema.arrayOf(AlertSchema),
  groupingBy: GroupingSchema,
  owner: _configSchema.schema.string(),
  rule: RuleSchema,
  timeWindow: TimeWindowSchema,
  reopenClosedCases: ReopenClosedCasesSchema,
  maximumCasesToOpen: _configSchema.schema.number({
    defaultValue: _constants.DEFAULT_MAX_OPEN_CASES,
    min: 1,
    max: _constants.MAX_OPEN_CASES
  })
});
const CasesConnectorRuleActionParamsSchema = exports.CasesConnectorRuleActionParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('run'),
  subActionParams: _configSchema.schema.object({
    groupingBy: GroupingSchema,
    reopenClosedCases: ReopenClosedCasesSchema,
    timeWindow: TimeWindowSchema
  })
});
const CasesConnectorParamsSchema = exports.CasesConnectorParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('run'),
  subActionParams: CasesConnectorRunParamsSchema
});