"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STATUS_EXTERNAL_TO_ESMODEL = exports.STATUS_ESMODEL_TO_EXTERNAL = exports.SEVERITY_EXTERNAL_TO_ESMODEL = exports.SEVERITY_ESMODEL_TO_EXTERNAL = exports.PUSH_CONNECTOR_ID_REFERENCE_NAME = exports.LICENSING_CASE_ASSIGNMENT_FEATURE = exports.EXTERNAL_REFERENCE_REF_NAME = exports.CONNECTOR_ID_REFERENCE_NAME = exports.COMMENT_REF_NAME = exports.CASE_REF_NAME = void 0;
var _domain = require("../../common/types/domain");
var _constants = require("../../common/constants");
var _case = require("./types/case");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The name of the saved object reference indicating the action connector ID. This is stored in the Saved Object reference
 * field's name property.
 */
const CONNECTOR_ID_REFERENCE_NAME = exports.CONNECTOR_ID_REFERENCE_NAME = 'connectorId';

/**
 * The name of the saved object reference indicating the action connector ID that was used to push a case.
 */
const PUSH_CONNECTOR_ID_REFERENCE_NAME = exports.PUSH_CONNECTOR_ID_REFERENCE_NAME = 'pushConnectorId';

/**
 * The name of the saved object reference indicating the caseId reference
 */
const CASE_REF_NAME = exports.CASE_REF_NAME = `associated-${_constants.CASE_SAVED_OBJECT}`;

/**
 * The name of the saved object reference indicating the commentId reference
 */
const COMMENT_REF_NAME = exports.COMMENT_REF_NAME = `associated-${_constants.CASE_COMMENT_SAVED_OBJECT}`;

/**
 * The name of the saved object reference indicating the externalReferenceId reference
 */
const EXTERNAL_REFERENCE_REF_NAME = exports.EXTERNAL_REFERENCE_REF_NAME = 'externalReferenceId';

/**
 * The name of the licensing feature to notify for feature usage with the licensing plugin
 */
const LICENSING_CASE_ASSIGNMENT_FEATURE = exports.LICENSING_CASE_ASSIGNMENT_FEATURE = 'Cases user assignment';
const SEVERITY_EXTERNAL_TO_ESMODEL = exports.SEVERITY_EXTERNAL_TO_ESMODEL = {
  [_domain.CaseSeverity.LOW]: _case.CasePersistedSeverity.LOW,
  [_domain.CaseSeverity.MEDIUM]: _case.CasePersistedSeverity.MEDIUM,
  [_domain.CaseSeverity.HIGH]: _case.CasePersistedSeverity.HIGH,
  [_domain.CaseSeverity.CRITICAL]: _case.CasePersistedSeverity.CRITICAL
};
const SEVERITY_ESMODEL_TO_EXTERNAL = exports.SEVERITY_ESMODEL_TO_EXTERNAL = {
  [_case.CasePersistedSeverity.LOW]: _domain.CaseSeverity.LOW,
  [_case.CasePersistedSeverity.MEDIUM]: _domain.CaseSeverity.MEDIUM,
  [_case.CasePersistedSeverity.HIGH]: _domain.CaseSeverity.HIGH,
  [_case.CasePersistedSeverity.CRITICAL]: _domain.CaseSeverity.CRITICAL
};
const STATUS_EXTERNAL_TO_ESMODEL = exports.STATUS_EXTERNAL_TO_ESMODEL = {
  [_domain.CaseStatuses.open]: _case.CasePersistedStatus.OPEN,
  [_domain.CaseStatuses['in-progress']]: _case.CasePersistedStatus.IN_PROGRESS,
  [_domain.CaseStatuses.closed]: _case.CasePersistedStatus.CLOSED
};
const STATUS_ESMODEL_TO_EXTERNAL = exports.STATUS_ESMODEL_TO_EXTERNAL = {
  [_case.CasePersistedStatus.OPEN]: _domain.CaseStatuses.open,
  [_case.CasePersistedStatus.IN_PROGRESS]: _domain.CaseStatuses['in-progress'],
  [_case.CasePersistedStatus.CLOSED]: _domain.CaseStatuses.closed
};