"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialConfiguration = exports.getConfigurationByOwner = void 0;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialConfiguration = exports.initialConfiguration = {
  closureType: 'close-by-user',
  connector: {
    fields: null,
    id: 'none',
    name: 'none',
    type: _common.ConnectorTypes.none
  },
  customFields: [],
  templates: [],
  mappings: [],
  version: '',
  id: '',
  owner: ''
};
const getConfigurationByOwner = ({
  configurations,
  owner
}) => {
  var _configurations$find;
  if (!configurations || !configurations.length || !owner) {
    return initialConfiguration;
  }

  // fallback to configuration 0 which was what happened before
  return (_configurations$find = configurations.find(element => element.owner === owner)) !== null && _configurations$find !== void 0 ? _configurations$find : initialConfiguration;
};
exports.getConfigurationByOwner = getConfigurationByOwner;