"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _config = require("./config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusStatsComponent = ({
  caseCount,
  caseStatus,
  isLoading,
  dataTestSubj
}) => {
  const statusStats = (0, _react.useMemo)(() => [{
    title: _config.statuses[caseStatus].stats.title,
    description: isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": `${dataTestSubj}-loading-spinner`
    }) : caseCount !== null && caseCount !== void 0 ? caseCount : '-'
  }], [caseCount, caseStatus, dataTestSubj, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": dataTestSubj,
    textStyle: "reverse",
    listItems: statusStats
  });
};
StatusStatsComponent.displayName = 'StatusStats';
const StatusStats = exports.StatusStats = /*#__PURE__*/(0, _react.memo)(StatusStatsComponent);