"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkButton = exports.LinkAnchor = exports.ConfigureCaseButton = exports.CaseDetailsLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _navigation = require("../../common/navigation");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkButton =
// TODO: Fix this manually. Issue #123375
// eslint-disable-next-line react/display-name
({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, props, children);

// TODO: Fix this manually. Issue #123375
// eslint-disable-next-line react/display-name
exports.LinkButton = LinkButton;
const LinkAnchor = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, props, children);
exports.LinkAnchor = LinkAnchor;
// TODO: Fix this manually. Issue #123375
// eslint-disable-next-line react/display-name
const CaseDetailsLinkComponent = ({
  children,
  detailName,
  title
}) => {
  const {
    getCaseViewUrl,
    navigateToCaseView
  } = (0, _navigation.useCaseViewNavigation)();
  const navigateToCaseViewClick = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToCaseView({
      detailName
    });
  }, [navigateToCaseView, detailName]);
  return /*#__PURE__*/_react.default.createElement(LinkAnchor, {
    onClick: navigateToCaseViewClick,
    href: getCaseViewUrl({
      detailName
    }),
    "data-test-subj": "case-details-link",
    "aria-label": i18n.CASE_DETAILS_LINK_ARIA(title !== null && title !== void 0 ? title : detailName)
  }, children ? children : detailName);
};
const CaseDetailsLink = exports.CaseDetailsLink = /*#__PURE__*/_react.default.memo(CaseDetailsLinkComponent);
CaseDetailsLink.displayName = 'CaseDetailsLink';
// TODO: Fix this manually. Issue #123375
// eslint-disable-next-line react/display-name
const ConfigureCaseButtonComponent = ({
  label,
  msgTooltip,
  showToolTip,
  titleTooltip
}) => {
  const {
    getConfigureCasesUrl,
    navigateToConfigureCases
  } = (0, _navigation.useConfigureCasesNavigation)();
  const navigateToConfigureCasesClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    navigateToConfigureCases();
  }, [navigateToConfigureCases]);
  const configureCaseButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(LinkButton, {
    onClick: navigateToConfigureCasesClick,
    href: getConfigureCasesUrl(),
    iconType: "controlsHorizontal",
    isDisabled: false,
    "aria-label": label,
    "data-test-subj": "configure-case-button"
  }, label), [label, navigateToConfigureCasesClick, getConfigureCasesUrl]);
  return showToolTip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    title: titleTooltip,
    content: /*#__PURE__*/_react.default.createElement("p", null, msgTooltip),
    "data-test-subj": "configure-case-tooltip"
  }, configureCaseButton) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, configureCaseButton);
};
const ConfigureCaseButton = exports.ConfigureCaseButton = /*#__PURE__*/_react.default.memo(ConfigureCaseButtonComponent);
ConfigureCaseButton.displayName = 'ConfigureCaseButton';