"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileActionsPopoverButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var i18n = _interopRequireWildcard(require("./translations"));
var _files = require("../../../common/files");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_cases_toast = require("../../common/use_cases_toast");
var _delete_attachment_confirmation_modal = require("../user_actions/delete_attachment_confirmation_modal");
var _use_delete_file_attachment = require("../../containers/use_delete_file_attachment");
var _use_delete_property_action = require("../user_actions/property_actions/use_delete_property_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileActionsPopoverButton = ({
  caseId,
  theFile
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    owner,
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    client: filesClient
  } = (0, _sharedUxFileContext.useFilesContext)();
  const {
    showSuccessToast
  } = (0, _use_cases_toast.useCasesToast)();
  const {
    isLoading,
    mutate: deleteFileAttachment
  } = (0, _use_delete_file_attachment.useDeleteFileAttachment)();
  const {
    showDeletionModal,
    onModalOpen,
    onConfirm,
    onCancel
  } = (0, _use_delete_property_action.useDeletePropertyAction)({
    onDelete: () => deleteFileAttachment({
      caseId,
      fileId: theFile.id
    })
  });
  const tooglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const panels = (0, _react.useMemo)(() => {
    var _theFile$hash, _theFile$hash2, _theFile$hash3, _theFile$hash4, _theFile$hash6, _theFile$hash8;
    const fileHashesAvailable = ((_theFile$hash = theFile.hash) === null || _theFile$hash === void 0 ? void 0 : _theFile$hash.md5) || ((_theFile$hash2 = theFile.hash) === null || _theFile$hash2 === void 0 ? void 0 : _theFile$hash2.sha1) || ((_theFile$hash3 = theFile.hash) === null || _theFile$hash3 === void 0 ? void 0 : _theFile$hash3.sha256);
    const mainPanelItems = [{
      name: i18n.DOWNLOAD_FILE,
      icon: 'download',
      href: filesClient.getDownloadHref({
        fileKind: (0, _files.constructFileKindIdByOwner)(owner[0]),
        id: theFile.id
      }),
      onClick: closePopover,
      'data-test-subj': 'cases-files-download-button'
    }];
    const panelsToBuild = [{
      id: 0,
      title: i18n.ACTIONS,
      items: mainPanelItems
    }, {
      id: 1,
      title: i18n.COPY_FILE_HASH,
      items: [{
        name: 'MD5',
        icon: 'copyClipboard',
        disabled: !((_theFile$hash4 = theFile.hash) !== null && _theFile$hash4 !== void 0 && _theFile$hash4.md5),
        onClick: () => {
          var _theFile$hash5;
          if ((_theFile$hash5 = theFile.hash) !== null && _theFile$hash5 !== void 0 && _theFile$hash5.md5) {
            navigator.clipboard.writeText(theFile.hash.md5).then(() => {
              closePopover();
              showSuccessToast(i18n.COPY_FILE_HASH_SUCCESS('md5'));
            });
          }
        },
        'data-test-subj': 'cases-files-copy-md5-hash-button'
      }, {
        name: 'SHA1',
        icon: 'copyClipboard',
        disabled: !((_theFile$hash6 = theFile.hash) !== null && _theFile$hash6 !== void 0 && _theFile$hash6.sha1),
        onClick: () => {
          var _theFile$hash7;
          if ((_theFile$hash7 = theFile.hash) !== null && _theFile$hash7 !== void 0 && _theFile$hash7.sha1) {
            navigator.clipboard.writeText(theFile.hash.sha1).then(() => {
              closePopover();
              showSuccessToast(i18n.COPY_FILE_HASH_SUCCESS('sha1'));
            });
          }
        },
        'data-test-subj': 'cases-files-copy-sha1-hash-button'
      }, {
        name: 'SHA256',
        icon: 'copyClipboard',
        disabled: !((_theFile$hash8 = theFile.hash) !== null && _theFile$hash8 !== void 0 && _theFile$hash8.sha256),
        onClick: () => {
          var _theFile$hash9;
          if ((_theFile$hash9 = theFile.hash) !== null && _theFile$hash9 !== void 0 && _theFile$hash9.sha256) {
            navigator.clipboard.writeText(theFile.hash.sha256).then(() => {
              closePopover();
              showSuccessToast(i18n.COPY_FILE_HASH_SUCCESS('sha256'));
            });
          }
        },
        'data-test-subj': 'cases-files-copy-sha256-hash-button'
      }]
    }];
    if (fileHashesAvailable) {
      mainPanelItems.push({
        name: i18n.COPY_FILE_HASH,
        icon: 'copyClipboard',
        panel: 1,
        'data-test-subj': 'cases-files-copy-hash-button'
      });
    }
    if (permissions.delete) {
      mainPanelItems.push({
        name: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: 'danger'
        }, i18n.DELETE_FILE),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "trash",
          size: "m",
          color: 'danger'
        }),
        onClick: () => {
          closePopover();
          onModalOpen();
        },
        disabled: isLoading,
        'data-test-subj': 'cases-files-delete-button'
      });
    }
    return panelsToBuild;
  }, [closePopover, filesClient, isLoading, onModalOpen, owner, permissions, showSuccessToast, theFile]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: `cases-files-popover-${theFile.id}`,
    key: `cases-files-popover-${theFile.id}`,
    "data-test-subj": `cases-files-popover-${theFile.id}`,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: tooglePopover,
      iconType: "boxesHorizontal",
      "aria-label": i18n.ACTIONS,
      color: "text",
      key: `cases-files-actions-popover-button-${theFile.id}`,
      "data-test-subj": `cases-files-actions-popover-button-${theFile.id}`
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    "data-test-subj": 'cases-files-popover-context-menu'
  })), showDeletionModal && /*#__PURE__*/_react.default.createElement(_delete_attachment_confirmation_modal.DeleteAttachmentConfirmationModal, {
    title: i18n.DELETE_FILE_TITLE,
    confirmButtonText: i18n.DELETE,
    onCancel: onCancel,
    onConfirm: onConfirm
  }));
};
exports.FileActionsPopoverButton = FileActionsPopoverButton;
FileActionsPopoverButton.displayName = 'FileActionsPopoverButton';