"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _domain = require("../../../../common/types/domain");
var _kibana = require("../../../common/lib/kibana");
var _card = require("../card");
var _use_get_choices = require("./use_get_choices");
var _helpers = require("./helpers");
var _deprecated_callout = require("../deprecated_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const choicesToGet = ['urgency', 'severity', 'impact', 'category', 'subcategory'];
const defaultFields = {
  urgency: [],
  severity: [],
  impact: [],
  category: [],
  subcategory: []
};
const ServiceNowITSMFieldsPreviewComponent = ({
  connector,
  fields
}) => {
  var _choicesData$data;
  const {
    severity = null,
    urgency = null,
    impact = null,
    category = null,
    subcategory = null
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const showConnectorWarning = connector.isDeprecated;
  const {
    isLoading,
    isFetching,
    data: choicesData
  } = (0, _use_get_choices.useGetChoices)({
    http,
    connector,
    fields: choicesToGet
  });
  const choices = (_choicesData$data = choicesData === null || choicesData === void 0 ? void 0 : choicesData.data) !== null && _choicesData$data !== void 0 ? _choicesData$data : [];
  const isLoadingChoices = isLoading || isFetching;
  const choicesFormatted = choices.reduce((acc, value) => ({
    ...acc,
    [value.element]: [...(acc[value.element] != null ? acc[value.element] : []), value]
  }), defaultFields);
  const categoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.category), [choicesFormatted.category]);
  const urgencyOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.urgency), [choicesFormatted.urgency]);
  const severityOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.severity), [choicesFormatted.severity]);
  const impactOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.impact), [choicesFormatted.impact]);
  const subcategoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.subcategory.filter(choice => choice.dependent_value === category)), [choicesFormatted.subcategory, category]);
  const listItems = (0, _react.useMemo)(() => {
    var _urgencyOptions$find$, _urgencyOptions$find, _severityOptions$find, _severityOptions$find2, _impactOptions$find$t, _impactOptions$find, _categoryOptions$find, _categoryOptions$find2, _subcategoryOptions$f, _subcategoryOptions$f2;
    return [...(urgency != null && urgency.length > 0 ? [{
      title: i18n.URGENCY,
      description: (_urgencyOptions$find$ = (_urgencyOptions$find = urgencyOptions.find(option => `${option.value}` === urgency)) === null || _urgencyOptions$find === void 0 ? void 0 : _urgencyOptions$find.text) !== null && _urgencyOptions$find$ !== void 0 ? _urgencyOptions$find$ : ''
    }] : []), ...(severity != null && severity.length > 0 ? [{
      title: i18n.SEVERITY,
      description: (_severityOptions$find = (_severityOptions$find2 = severityOptions.find(option => `${option.value}` === severity)) === null || _severityOptions$find2 === void 0 ? void 0 : _severityOptions$find2.text) !== null && _severityOptions$find !== void 0 ? _severityOptions$find : ''
    }] : []), ...(impact != null && impact.length > 0 ? [{
      title: i18n.IMPACT,
      description: (_impactOptions$find$t = (_impactOptions$find = impactOptions.find(option => `${option.value}` === impact)) === null || _impactOptions$find === void 0 ? void 0 : _impactOptions$find.text) !== null && _impactOptions$find$t !== void 0 ? _impactOptions$find$t : ''
    }] : []), ...(category != null && category.length > 0 ? [{
      title: i18n.CATEGORY,
      description: (_categoryOptions$find = (_categoryOptions$find2 = categoryOptions.find(option => `${option.value}` === category)) === null || _categoryOptions$find2 === void 0 ? void 0 : _categoryOptions$find2.text) !== null && _categoryOptions$find !== void 0 ? _categoryOptions$find : ''
    }] : []), ...(subcategory != null && subcategory.length > 0 ? [{
      title: i18n.SUBCATEGORY,
      description: (_subcategoryOptions$f = (_subcategoryOptions$f2 = subcategoryOptions.find(option => `${option.value}` === subcategory)) === null || _subcategoryOptions$f2 === void 0 ? void 0 : _subcategoryOptions$f2.text) !== null && _subcategoryOptions$f !== void 0 ? _subcategoryOptions$f : ''
    }] : [])];
  }, [category, categoryOptions, impact, impactOptions, severity, severityOptions, subcategory, subcategoryOptions, urgency, urgencyOptions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showConnectorWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_deprecated_callout.DeprecatedCallout, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _domain.ConnectorTypes.serviceNowITSM,
    title: connector.name,
    listItems: listItems,
    isLoading: isLoadingChoices
  }))));
};
exports.default = ServiceNowITSMFieldsPreviewComponent;
ServiceNowITSMFieldsPreviewComponent.displayName = 'ServiceNowITSMFieldsPreview';
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;