"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _connectors_dropdown = require("../configure_cases/connectors_dropdown");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorSelector = ({
  connectors,
  dataTestSubj,
  disabled = false,
  field,
  idAria,
  isLoading = false,
  handleChange
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const onChange = (0, _react.useCallback)(val => {
    if (handleChange) {
      handleChange(val);
    }
    field.setValue(val);
  }, [handleChange, field]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: (0, _react2.css)`
        .euiFormErrorText {
          display: none;
        }
      `,
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    error: errorMessage,
    fullWidth: true,
    helpText: field.helpText,
    isInvalid: isInvalid,
    label: field.label,
    labelAppend: field.labelAppend
  }, /*#__PURE__*/_react.default.createElement(_connectors_dropdown.ConnectorsDropdown, {
    connectors: connectors,
    disabled: disabled,
    isLoading: isLoading,
    onChange: onChange,
    selectedConnector: (0, _fp.isEmpty)(field.value) ? 'none' : field.value
  }));
};
exports.ConnectorSelector = ConnectorSelector;
ConnectorSelector.displayName = 'ConnectorSelector';