"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectors = exports.actionTypes = void 0;
Object.defineProperty(exports, "mappings", {
  enumerable: true,
  get: function () {
    return _mock2.mappings;
  }
});
exports.usePersistConfigurationMockResponse = exports.useGetAllCaseConfigurationsResponse = exports.useConnectorsResponse = exports.useCaseConfigureResponse = exports.useActionTypesResponse = exports.searchURL = void 0;
var _mock = require("../../../common/mock");
var _domain = require("../../../../common/types/domain");
var _connectors = require("../../../common/mock/connectors");
var _mock2 = require("../../../containers/configure/mock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const connectors = exports.connectors = _connectors.connectorsMock;
const actionTypes = exports.actionTypes = _connectors.actionTypesMock;
const searchURL = exports.searchURL = '?timerange=(global:(linkTo:!(),timerange:(from:1585487656371,fromStr:now-24h,kind:relative,to:1585574056371,toStr:now)),timeline:(linkTo:!(),timerange:(from:1585227005527,kind:absolute,to:1585313405527)))';
const mockConfigurationData = {
  closureType: 'close-by-user',
  connector: {
    fields: null,
    id: 'none',
    name: 'none',
    type: _domain.ConnectorTypes.none
  },
  customFields: [],
  templates: [],
  mappings: [],
  version: '',
  id: '',
  owner: _mock.mockedTestProvidersOwner[0]
};
const useCaseConfigureResponse = exports.useCaseConfigureResponse = {
  data: mockConfigurationData,
  isLoading: false,
  isFetching: false,
  refetch: jest.fn()
};
const useGetAllCaseConfigurationsResponse = exports.useGetAllCaseConfigurationsResponse = {
  data: [mockConfigurationData],
  isLoading: false,
  isFetching: false,
  refetch: jest.fn()
};
const usePersistConfigurationMockResponse = exports.usePersistConfigurationMockResponse = {
  isLoading: false,
  mutate: jest.fn(),
  mutateAsync: jest.fn()
};
const useConnectorsResponse = exports.useConnectorsResponse = {
  isLoading: false,
  data: connectors,
  refetch: jest.fn()
};
const useActionTypesResponse = exports.useActionTypesResponse = {
  isLoading: false,
  data: _connectors.actionTypesMock,
  refetch: jest.fn()
};