"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUICapabilities = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUICapabilities = featureCapabilities => {
  const create = !!(featureCapabilities !== null && featureCapabilities !== void 0 && featureCapabilities[_constants.CREATE_CASES_CAPABILITY]);
  const read = !!(featureCapabilities !== null && featureCapabilities !== void 0 && featureCapabilities[_constants.READ_CASES_CAPABILITY]);
  const update = !!(featureCapabilities !== null && featureCapabilities !== void 0 && featureCapabilities[_constants.UPDATE_CASES_CAPABILITY]);
  const deletePriv = !!(featureCapabilities !== null && featureCapabilities !== void 0 && featureCapabilities[_constants.DELETE_CASES_CAPABILITY]);
  const push = !!(featureCapabilities !== null && featureCapabilities !== void 0 && featureCapabilities[_constants.PUSH_CASES_CAPABILITY]);
  const connectors = !!(featureCapabilities !== null && featureCapabilities !== void 0 && featureCapabilities[_constants.CASES_CONNECTORS_CAPABILITY]);
  const settings = !!(featureCapabilities !== null && featureCapabilities !== void 0 && featureCapabilities[_constants.CASES_SETTINGS_CAPABILITY]);
  const all = create && read && update && deletePriv && push && connectors && settings;
  return {
    all,
    create,
    read,
    update,
    delete: deletePriv,
    push,
    connectors,
    settings
  };
};
exports.getUICapabilities = getUICapabilities;