"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToggleCustomFieldConfigurationRt = exports.TextCustomFieldConfigurationRt = exports.TemplatesConfigurationRt = exports.TemplateConfigurationRt = exports.CustomFieldsConfigurationRt = exports.CustomFieldConfigurationWithoutTypeRt = exports.CustomFieldConfigurationRt = exports.ConfigurationsRt = exports.ConfigurationRt = exports.ConfigurationBasicWithoutOwnerRt = exports.ConfigurationAttributesRt = exports.ConfigurationActivityFieldsRt = exports.ClosureTypeRt = exports.CasesConfigureBasicRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _v = require("../connector/v1");
var _v2 = require("../user/v1");
var _v3 = require("../custom_field/v1");
var _v4 = require("../case/v1");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ClosureTypeRt = exports.ClosureTypeRt = rt.union([rt.literal('close-by-user'), rt.literal('close-by-pushing')]);
const CustomFieldConfigurationWithoutTypeRt = exports.CustomFieldConfigurationWithoutTypeRt = rt.strict({
  /**
   * key of custom field
   */
  key: rt.string,
  /**
   * label of custom field
   */
  label: rt.string,
  /**
   * custom field options - required
   */
  required: rt.boolean
});
const TextCustomFieldConfigurationRt = exports.TextCustomFieldConfigurationRt = rt.intersection([rt.strict({
  type: _v3.CustomFieldTextTypeRt
}), CustomFieldConfigurationWithoutTypeRt, rt.exact(rt.partial({
  defaultValue: rt.union([rt.string, rt.null])
}))]);
const ToggleCustomFieldConfigurationRt = exports.ToggleCustomFieldConfigurationRt = rt.intersection([rt.strict({
  type: _v3.CustomFieldToggleTypeRt
}), CustomFieldConfigurationWithoutTypeRt, rt.exact(rt.partial({
  defaultValue: rt.union([rt.boolean, rt.null])
}))]);
const CustomFieldConfigurationRt = exports.CustomFieldConfigurationRt = rt.union([TextCustomFieldConfigurationRt, ToggleCustomFieldConfigurationRt]);
const CustomFieldsConfigurationRt = exports.CustomFieldsConfigurationRt = rt.array(CustomFieldConfigurationRt);
const TemplateConfigurationRt = exports.TemplateConfigurationRt = rt.intersection([rt.strict({
  /**
   * key of template
   */
  key: rt.string,
  /**
   * name of template
   */
  name: rt.string,
  /**
   * case fields of template
   */
  caseFields: rt.union([rt.null, _v4.CaseBaseOptionalFieldsRt])
}), rt.exact(rt.partial({
  /**
   * description of template
   */
  description: rt.string,
  /**
   * tags of template
   */
  tags: rt.array(rt.string)
}))]);
const TemplatesConfigurationRt = exports.TemplatesConfigurationRt = rt.array(TemplateConfigurationRt);
const ConfigurationBasicWithoutOwnerRt = exports.ConfigurationBasicWithoutOwnerRt = rt.strict({
  /**
   * The external connector
   */
  connector: _v.CaseConnectorRt,
  /**
   * Whether to close the case after it has been synced with the external system
   */
  closure_type: ClosureTypeRt,
  /**
   * The custom fields configured for the case
   */
  customFields: CustomFieldsConfigurationRt,
  /**
   * Templates configured for the case
   */
  templates: TemplatesConfigurationRt
});
const CasesConfigureBasicRt = exports.CasesConfigureBasicRt = rt.intersection([ConfigurationBasicWithoutOwnerRt, rt.strict({
  /**
   * The plugin owner that manages this configuration
   */
  owner: rt.string
})]);
const ConfigurationActivityFieldsRt = exports.ConfigurationActivityFieldsRt = rt.strict({
  created_at: rt.string,
  created_by: _v2.UserRt,
  updated_at: rt.union([rt.string, rt.null]),
  updated_by: rt.union([_v2.UserRt, rt.null])
});
const ConfigurationAttributesRt = exports.ConfigurationAttributesRt = rt.intersection([CasesConfigureBasicRt, ConfigurationActivityFieldsRt]);
const ConfigurationRt = exports.ConfigurationRt = rt.intersection([ConfigurationAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string,
  error: rt.union([rt.string, rt.null]),
  owner: rt.string,
  mappings: _v.ConnectorMappingsRt
})]);
const ConfigurationsRt = exports.ConfigurationsRt = rt.array(ConfigurationRt);