"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindAttachmentsQueryParamsRt = exports.BulkGetAttachmentsResponseRt = exports.BulkGetAttachmentsRequestRt = exports.BulkDeleteFileAttachmentsRequestRt = exports.BulkCreateAttachmentsRequestRt = exports.AttachmentsFindResponseRt = exports.AttachmentRequestWithoutRefsRt = exports.AttachmentRequestRt = exports.AttachmentPatchRequestRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _constants = require("../../../constants");
var _schema = require("../../../schema");
var _v = require("../../domain/attachment/v1");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Files
 */

const MIN_DELETE_IDS = 1;
const BulkDeleteFileAttachmentsRequestRt = exports.BulkDeleteFileAttachmentsRequestRt = rt.strict({
  ids: (0, _schema.limitedArraySchema)({
    codec: _schema.NonEmptyString,
    min: MIN_DELETE_IDS,
    max: _constants.MAX_DELETE_FILES,
    fieldName: 'ids'
  })
});
const BasicAttachmentRequestRt = rt.union([_v.UserCommentAttachmentPayloadRt, _v.AlertAttachmentPayloadRt, _v.ActionsAttachmentPayloadRt, _v.ExternalReferenceNoSOAttachmentPayloadRt, _v.PersistableStateAttachmentPayloadRt]);
const AttachmentRequestRt = exports.AttachmentRequestRt = rt.union([rt.strict({
  comment: (0, _schema.limitedStringSchema)({
    fieldName: 'comment',
    min: 1,
    max: _constants.MAX_COMMENT_LENGTH
  }),
  type: rt.literal(_v.AttachmentType.user),
  owner: rt.string
}), _v.AlertAttachmentPayloadRt, rt.strict({
  type: rt.literal(_v.AttachmentType.actions),
  comment: (0, _schema.limitedStringSchema)({
    fieldName: 'comment',
    min: 1,
    max: _constants.MAX_COMMENT_LENGTH
  }),
  actions: rt.strict({
    targets: rt.array(rt.strict({
      hostname: rt.string,
      endpointId: rt.string
    })),
    type: rt.string
  }),
  owner: rt.string
}), _v.ExternalReferenceNoSOAttachmentPayloadRt, _v.ExternalReferenceSOAttachmentPayloadRt, _v.PersistableStateAttachmentPayloadRt]);
const AttachmentRequestWithoutRefsRt = exports.AttachmentRequestWithoutRefsRt = rt.union([BasicAttachmentRequestRt, _v.ExternalReferenceSOWithoutRefsAttachmentPayloadRt]);
const AttachmentPatchRequestRt = exports.AttachmentPatchRequestRt = rt.intersection([
/**
 * Partial updates are not allowed.
 * We want to prevent the user for changing the type without removing invalid fields.
 *
 * injectAttachmentSOAttributesFromRefsForPatch is dependent on this assumption.
 * The consumers of the persistable attachment service should always get the
 * persistableStateAttachmentState on a patch.
 */
AttachmentRequestRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
const AttachmentsFindResponseRt = exports.AttachmentsFindResponseRt = rt.strict({
  comments: rt.array(_v.AttachmentRt),
  page: rt.number,
  per_page: rt.number,
  total: rt.number
});
const FindAttachmentsQueryParamsRt = exports.FindAttachmentsQueryParamsRt = rt.intersection([rt.exact(rt.partial({
  /**
   * Order to sort the response
   */
  sortOrder: rt.union([rt.literal('desc'), rt.literal('asc')])
})), (0, _schema.paginationSchema)({
  maxPerPage: _constants.MAX_COMMENTS_PER_PAGE
})]);
const BulkCreateAttachmentsRequestRt = exports.BulkCreateAttachmentsRequestRt = (0, _schema.limitedArraySchema)({
  codec: AttachmentRequestRt,
  min: 0,
  max: _constants.MAX_BULK_CREATE_ATTACHMENTS,
  fieldName: 'attachments'
});
const BulkGetAttachmentsRequestRt = exports.BulkGetAttachmentsRequestRt = rt.strict({
  ids: (0, _schema.limitedArraySchema)({
    codec: rt.string,
    min: 1,
    max: _constants.MAX_BULK_GET_ATTACHMENTS,
    fieldName: 'ids'
  })
});
const BulkGetAttachmentsResponseRt = exports.BulkGetAttachmentsResponseRt = rt.strict({
  attachments: _v.AttachmentsRt,
  errors: rt.array(rt.strict({
    error: rt.string,
    message: rt.string,
    status: rt.union([rt.undefined, rt.number]),
    attachmentId: rt.string
  }))
});