"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.workpadReducer = void 0;
var _reduxActions = require("redux-actions");
var _services = require("../../services");
var _defaults = require("../defaults");
var _workpad = require("../actions/workpad");
var _constants = require("../../../common/lib/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const workpadReducer = exports.workpadReducer = (0, _reduxActions.handleActions)({
  [_workpad.setWorkpad]: (workpadState, {
    payload
  }) => {
    _services.pluginServices.getServices().platform.setRecentlyAccessed(`${_constants.APP_ROUTE_WORKPAD}/${payload.id}`, payload.name, payload.id);
    return payload;
  },
  [_workpad.sizeWorkpad]: (workpadState, {
    payload
  }) => {
    return {
      ...workpadState,
      ...payload
    };
  },
  [_workpad.setColors]: (workpadState, {
    payload
  }) => {
    return {
      ...workpadState,
      colors: payload
    };
  },
  [_workpad.setName]: (workpadState, {
    payload
  }) => {
    _services.pluginServices.getServices().platform.setRecentlyAccessed(`${_constants.APP_ROUTE_WORKPAD}/${workpadState.id}`, payload, workpadState.id);
    return {
      ...workpadState,
      name: payload
    };
  },
  [_workpad.setWriteable]: (workpadState, {
    payload
  }) => {
    return {
      ...workpadState,
      isWriteable: Boolean(payload)
    };
  },
  [_workpad.setWorkpadCSS]: (workpadState, {
    payload
  }) => {
    return {
      ...workpadState,
      css: payload
    };
  },
  [_workpad.setWorkpadVariables]: (workpadState, {
    payload
  }) => {
    return {
      ...workpadState,
      variables: payload
    };
  },
  [_workpad.resetWorkpad]: () => ({
    ...(0, _defaults.getDefaultWorkpad)()
  })
}, {});