"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  pluginServiceProviders: true,
  pluginServiceRegistry: true,
  customElementServiceFactory: true,
  dataViewsServiceFactory: true,
  expressionsServiceFactory: true,
  labsServiceFactory: true,
  navLinkServiceFactory: true,
  notifyServiceFactory: true,
  platformServiceFactory: true,
  reportingServiceFactory: true,
  visualizationsServiceFactory: true,
  workpadServiceFactory: true,
  filtersServiceFactory: true
};
Object.defineProperty(exports, "customElementServiceFactory", {
  enumerable: true,
  get: function () {
    return _custom_element.customElementServiceFactory;
  }
});
Object.defineProperty(exports, "dataViewsServiceFactory", {
  enumerable: true,
  get: function () {
    return _data_views.dataViewsServiceFactory;
  }
});
Object.defineProperty(exports, "expressionsServiceFactory", {
  enumerable: true,
  get: function () {
    return _expressions.expressionsServiceFactory;
  }
});
Object.defineProperty(exports, "filtersServiceFactory", {
  enumerable: true,
  get: function () {
    return _filters.filtersServiceFactory;
  }
});
Object.defineProperty(exports, "labsServiceFactory", {
  enumerable: true,
  get: function () {
    return _labs.labsServiceFactory;
  }
});
Object.defineProperty(exports, "navLinkServiceFactory", {
  enumerable: true,
  get: function () {
    return _nav_link.navLinkServiceFactory;
  }
});
Object.defineProperty(exports, "notifyServiceFactory", {
  enumerable: true,
  get: function () {
    return _notify.notifyServiceFactory;
  }
});
Object.defineProperty(exports, "platformServiceFactory", {
  enumerable: true,
  get: function () {
    return _platform.platformServiceFactory;
  }
});
exports.pluginServiceRegistry = exports.pluginServiceProviders = void 0;
Object.defineProperty(exports, "reportingServiceFactory", {
  enumerable: true,
  get: function () {
    return _reporting.reportingServiceFactory;
  }
});
Object.defineProperty(exports, "visualizationsServiceFactory", {
  enumerable: true,
  get: function () {
    return _visualizations.visualizationsServiceFactory;
  }
});
Object.defineProperty(exports, "workpadServiceFactory", {
  enumerable: true,
  get: function () {
    return _workpad.workpadServiceFactory;
  }
});
var _stubs = require("../legacy/stubs");
Object.keys(_stubs).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _stubs[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _stubs[key];
    }
  });
});
var _public = require("@kbn/presentation-util-plugin/public");
var _custom_element = require("./custom_element");
var _data_views = require("./data_views");
var _embeddables = require("./embeddables");
var _expressions = require("./expressions");
var _labs = require("./labs");
var _nav_link = require("./nav_link");
var _notify = require("./notify");
var _platform = require("./platform");
var _reporting = require("./reporting");
var _visualizations = require("./visualizations");
var _workpad = require("./workpad");
var _filters = require("./filters");
var _ui_actions = require("./ui_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pluginServiceProviders = exports.pluginServiceProviders = {
  customElement: new _public.PluginServiceProvider(_custom_element.customElementServiceFactory),
  dataViews: new _public.PluginServiceProvider(_data_views.dataViewsServiceFactory),
  embeddables: new _public.PluginServiceProvider(_embeddables.embeddablesServiceFactory),
  expressions: new _public.PluginServiceProvider(_expressions.expressionsServiceFactory, ['filters', 'notify']),
  filters: new _public.PluginServiceProvider(_filters.filtersServiceFactory),
  labs: new _public.PluginServiceProvider(_labs.labsServiceFactory),
  navLink: new _public.PluginServiceProvider(_nav_link.navLinkServiceFactory),
  notify: new _public.PluginServiceProvider(_notify.notifyServiceFactory),
  platform: new _public.PluginServiceProvider(_platform.platformServiceFactory),
  reporting: new _public.PluginServiceProvider(_reporting.reportingServiceFactory),
  visualizations: new _public.PluginServiceProvider(_visualizations.visualizationsServiceFactory),
  workpad: new _public.PluginServiceProvider(_workpad.workpadServiceFactory),
  uiActions: new _public.PluginServiceProvider(_ui_actions.uiActionsServiceFactory)
};
const pluginServiceRegistry = exports.pluginServiceRegistry = new _public.PluginServiceRegistry(pluginServiceProviders);