"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customElementServiceFactory = void 0;
var _constants = require("../../../common/lib/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const customElementServiceFactory = ({
  coreStart
}) => {
  const {
    http
  } = coreStart;
  const apiPath = `${_constants.API_ROUTE_CUSTOM_ELEMENT}`;
  return {
    create: customElement => http.post(apiPath, {
      body: JSON.stringify(customElement),
      version: '1'
    }),
    get: customElementId => http.get(`${apiPath}/${customElementId}`, {
      version: '1'
    }).then(({
      data: element
    }) => element),
    update: (id, element) => http.put(`${apiPath}/${id}`, {
      body: JSON.stringify(element),
      version: '1'
    }),
    remove: id => http.delete(`${apiPath}/${id}`, {
      version: '1'
    }),
    find: async name => {
      return http.get(`${apiPath}/find`, {
        query: {
          name,
          perPage: 10000
        },
        version: '1'
      });
    }
  };
};
exports.customElementServiceFactory = customElementServiceFactory;