"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CanvasPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _feature_catalogue_entry = require("./feature_catalogue_entry");
var _locator = require("../common/locator");
var _constants = require("../common/lib/constants");
var _storage = require("./lib/storage");
var _loading_indicator = require("./lib/loading_indicator");
var _plugin_api = require("./plugin_api");
var _setup_expressions = require("./setup_expressions");
var _add_canvas_element_trigger = require("./state/triggers/add_canvas_element_trigger");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * These are the private interfaces for the services your plugin depends on.
 * @internal
 */
// This interface will be built out as we require other plugins for setup

/**
 * These are the interfaces with your public contracts. You should export these
 * for other plugins to use in _their_ `SetupDeps`/`StartDeps` interfaces.
 * @public
 */
// These interfaces are empty for now but will be populate as we need to export
// things for other plugins to use at startup or runtime

/** @internal */
class CanvasPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "appUpdater", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "initContext", void 0);
    this.initContext = initContext;
  }
  setup(coreSetup, setupPlugins) {
    const {
      api: canvasApi,
      registries
    } = (0, _plugin_api.getPluginApi)(setupPlugins.expressions);

    // Set the nav link to the last saved url if we have one in storage
    const lastPath = (0, _storage.getSessionStorage)().get(`${_constants.SESSIONSTORAGE_LASTPATH}:${coreSetup.http.basePath.get()}`);
    if (lastPath) {
      this.appUpdater.next(() => ({
        defaultPath: `#${lastPath}`
      }));
    }
    coreSetup.application.register({
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      id: _constants.CANVAS_APP,
      title: 'Canvas',
      euiIconType: 'logoKibana',
      order: 3000,
      updater$: this.appUpdater,
      mount: async params => {
        const {
          CanvasSrcPlugin
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../canvas_plugin_src/plugin')));
        const srcPlugin = new CanvasSrcPlugin();
        srcPlugin.setup(coreSetup, {
          canvas: canvasApi
        });
        (0, _setup_expressions.setupExpressions)({
          coreSetup,
          setupPlugins
        });

        // Get start services
        const [coreStart, startPlugins] = await coreSetup.getStartServices();
        srcPlugin.start(coreStart, startPlugins);
        const {
          pluginServices
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services')));
        const {
          pluginServiceRegistry
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/kibana')));
        pluginServices.setRegistry(pluginServiceRegistry.start({
          coreStart,
          startPlugins,
          appUpdater: this.appUpdater,
          initContext: this.initContext
        }));
        const {
          expressions,
          presentationUtil
        } = startPlugins;
        await presentationUtil.registerExpressionsLanguage(Object.values(expressions.getFunctions()));

        // Load application bundle
        const {
          renderApp,
          initializeCanvas,
          teardownCanvas
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const canvasStore = await initializeCanvas(coreSetup, coreStart, setupPlugins, startPlugins, registries, this.appUpdater);
        const unmount = renderApp({
          coreStart,
          startPlugins,
          params,
          canvasStore,
          pluginServices
        });
        return () => {
          unmount();
          teardownCanvas(coreStart);
        };
      }
    });
    if (setupPlugins.home) {
      setupPlugins.home.featureCatalogue.register(_feature_catalogue_entry.featureCatalogueEntry);
    }
    if (setupPlugins.share) {
      setupPlugins.share.url.locators.create(new _locator.CanvasAppLocatorDefinition());
    }
    canvasApi.addArgumentUIs(async () => {
      // @ts-expect-error
      const {
        argTypeSpecs
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./expression_types/arg_types')));
      return argTypeSpecs;
    });
    canvasApi.addTransitions(async () => {
      const {
        transitions
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./transitions')));
      return transitions;
    });
    setupPlugins.uiActions.registerTrigger(_add_canvas_element_trigger.addCanvasElementTrigger);
    return {
      ...canvasApi
    };
  }
  start(coreStart, startPlugins) {
    (0, _loading_indicator.initLoadingIndicator)(coreStart.http.addLoadingCountSource);
  }
}
exports.CanvasPlugin = CanvasPlugin;