"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notifyError = exports.createAsset = void 0;
var _i18n = require("@kbn/i18n");
var _get_id = require("./get_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getSaveFailureTitle: () => _i18n.i18n.translate('xpack.canvas.error.esPersist.saveFailureTitle', {
    defaultMessage: "Couldn't save your changes to Elasticsearch"
  }),
  getTooLargeErrorMessage: () => _i18n.i18n.translate('xpack.canvas.error.esPersist.tooLargeErrorMessage', {
    defaultMessage: 'The server gave a response that the workpad data was too large. This usually means uploaded image assets that are too large for Kibana or a proxy. Try removing some assets in the asset manager.'
  }),
  getUpdateFailureTitle: () => _i18n.i18n.translate('xpack.canvas.error.esPersist.updateFailureTitle', {
    defaultMessage: "Couldn't update workpad"
  })
};
const createAsset = (type, content) => ({
  id: (0, _get_id.getId)('asset'),
  type,
  value: content,
  '@created': new Date().toISOString()
});
exports.createAsset = createAsset;
const notifyError = (err, notifyErrorFn) => {
  const statusCode = err.response && err.response.status;
  switch (statusCode) {
    case 400:
      return notifyErrorFn(err.response, {
        title: strings.getSaveFailureTitle()
      });
    case 413:
      return notifyErrorFn(strings.getTooLargeErrorMessage(), {
        title: strings.getSaveFailureTitle()
      });
    default:
      return notifyErrorFn(err, {
        title: strings.getUpdateFailureTitle()
      });
  }
};
exports.notifyError = notifyError;