"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _services = require("../../../services");
var _workpad = require("../../../state/selectors/workpad");
var _hooks = require("../../hooks");
var _share_menu = require("./share_menu.component");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getUnknownExportErrorMessage: type => _i18n.i18n.translate('xpack.canvas.workpadHeaderShareMenu.unknownExportErrorMessage', {
    defaultMessage: 'Unknown export type: {type}',
    values: {
      type
    }
  })
};
const ShareMenu = () => {
  const downloadWorkpad = (0, _hooks.useDownloadWorkpad)();
  const reportingService = (0, _services.useReportingService)();
  const platformService = (0, _services.usePlatformService)();
  const {
    workpad,
    pageCount
  } = (0, _reactRedux.useSelector)(state => ({
    workpad: (0, _workpad.getWorkpad)(state),
    pageCount: (0, _workpad.getPages)(state).length
  }));
  const ReportingPanelPDFComponent = reportingService.getReportingPanelPDFComponent();
  const sharingData = {
    workpad,
    pageCount
  };
  const ReportingComponent = ReportingPanelPDFComponent !== null ? ({
    onClose
  }) => /*#__PURE__*/_react.default.createElement(ReportingPanelPDFComponent, {
    getJobParams: () => (0, _utils.getPdfJobParams)(sharingData, platformService.getKibanaVersion()),
    layoutOption: "canvas",
    onClose: onClose,
    objectId: workpad.id
  }) : null;
  const onExport = (0, _react.useCallback)(type => {
    switch (type) {
      case 'pdf':
        // notifications are automatically handled by the Reporting plugin
        break;
      case 'json':
        downloadWorkpad(workpad.id);
        return;
      default:
        throw new Error(strings.getUnknownExportErrorMessage(type));
    }
  }, [downloadWorkpad, workpad]);
  return /*#__PURE__*/_react.default.createElement(_share_menu.ShareMenu, {
    ReportingComponent,
    onExport
  });
};
exports.ShareMenu = ShareMenu;