"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDownloadZippedRuntime = exports.useDownloadRuntime = void 0;
var _react = require("react");
var _fileSaver = _interopRequireDefault(require("file-saver"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/lib/constants");
var _constants2 = require("../../../../../../i18n/constants");
var _services = require("../../../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getDownloadRuntimeFailureErrorMessage: () => _i18n.i18n.translate('xpack.canvas.error.downloadWorkpad.downloadRuntimeFailureErrorMessage', {
    defaultMessage: "Couldn't download Shareable Runtime"
  }),
  getDownloadZippedRuntimeFailureErrorMessage: () => _i18n.i18n.translate('xpack.canvas.error.downloadWorkpad.downloadZippedRuntimeFailureErrorMessage', {
    defaultMessage: "Couldn't download ZIP file"
  }),
  getShareableZipErrorTitle: workpadName => _i18n.i18n.translate('xpack.canvas.workpadHeaderShareMenu.shareWebsiteErrorTitle', {
    defaultMessage: "Failed to create {ZIP} file for ''{workpadName}''. The workpad may be too large. You'll need to download the files separately.",
    values: {
      ZIP: _constants2.ZIP,
      workpadName
    }
  })
};
const useDownloadRuntime = () => {
  const platformService = (0, _services.usePlatformService)();
  const notifyService = (0, _services.useNotifyService)();
  const downloadRuntime = (0, _react.useCallback)(() => {
    try {
      const path = `${platformService.getBasePath()}${_constants.API_ROUTE_SHAREABLE_RUNTIME_DOWNLOAD}`;
      window.open(path);
      return;
    } catch (err) {
      notifyService.error(err, {
        title: strings.getDownloadRuntimeFailureErrorMessage()
      });
    }
  }, [platformService, notifyService]);
  return downloadRuntime;
};
exports.useDownloadRuntime = useDownloadRuntime;
const useDownloadZippedRuntime = () => {
  const workpadService = (0, _services.useWorkpadService)();
  const notifyService = (0, _services.useNotifyService)();
  const downloadZippedRuntime = (0, _react.useCallback)(workpad => {
    const downloadZip = async () => {
      try {
        let runtimeZipBlob;
        try {
          runtimeZipBlob = await workpadService.getRuntimeZip(workpad);
        } catch (err) {
          notifyService.error(err, {
            title: strings.getShareableZipErrorTitle(workpad.name)
          });
        }
        if (runtimeZipBlob) {
          _fileSaver.default.saveAs(runtimeZipBlob, 'canvas-workpad-embed.zip');
        }
      } catch (err) {
        notifyService.error(err, {
          title: strings.getDownloadZippedRuntimeFailureErrorMessage()
        });
      }
    };
    downloadZip();
  }, [notifyService, workpadService]);
  return downloadZippedRuntime;
};
exports.useDownloadZippedRuntime = useDownloadZippedRuntime;