"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/visualizations-plugin/public");
var _ui_metric = require("../../../lib/ui_metric");
var _services = require("../../../services");
var _lib = require("../../../../common/lib");
var _editor_menu = require("./editor_menu.component");
var _embeddable_input_to_expression = require("../../../../canvas_plugin_src/renderers/embeddable/embeddable_input_to_expression");
var _use_canvas_api = require("../../hooks/use_canvas_api");
var _add_canvas_element_trigger = require("../../../state/triggers/add_canvas_element_trigger");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditorMenu = ({
  addElement
}) => {
  const embeddablesService = (0, _services.useEmbeddablesService)();
  const {
    pathname,
    search,
    hash
  } = (0, _reactRouterDom.useLocation)();
  const stateTransferService = embeddablesService.getStateTransfer();
  const visualizationsService = (0, _services.useVisualizationsService)();
  const uiActions = (0, _services.useUiActionsService)();
  const canvasApi = (0, _use_canvas_api.useCanvasApi)();
  const [addPanelActions, setAddPanelActions] = (0, _react.useState)([]);
  const embeddableFactories = (0, _react.useMemo)(() => embeddablesService ? Array.from(embeddablesService.getEmbeddableFactories()) : [], [embeddablesService]);
  const [unwrappedEmbeddableFactories, setUnwrappedEmbeddableFactories] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    Promise.all(embeddableFactories.map(async factory => ({
      factory,
      isEditable: await factory.isEditable()
    }))).then(factories => {
      setUnwrappedEmbeddableFactories(factories);
    });
  }, [embeddableFactories]);
  (0, _react.useEffect)(() => {
    let mounted = true;
    async function loadPanelActions() {
      var _uiActions$getTrigger;
      const registeredActions = await (uiActions === null || uiActions === void 0 ? void 0 : (_uiActions$getTrigger = uiActions.getTriggerCompatibleActions) === null || _uiActions$getTrigger === void 0 ? void 0 : _uiActions$getTrigger.call(uiActions, _add_canvas_element_trigger.ADD_CANVAS_ELEMENT_TRIGGER, {
        embeddable: canvasApi
      }));
      if (mounted) setAddPanelActions(registeredActions);
    }
    loadPanelActions();
    return () => {
      mounted = false;
    };
  }, [uiActions, canvasApi]);
  const createNewVisType = (0, _react.useCallback)(visType => () => {
    let path = '';
    let appId = '';
    if (visType) {
      if (_ui_metric.trackCanvasUiMetric) {
        (0, _ui_metric.trackCanvasUiMetric)(_ui_metric.METRIC_TYPE.CLICK, `${visType.name}:create`);
      }
      if (!('alias' in visType)) {
        // this visualization is not an alias
        appId = 'visualize';
        path = `#/create?type=${encodeURIComponent(visType.name)}`;
      } else if (visType.alias && 'path' in visType.alias) {
        // this visualization **is** an alias, and it has an app to redirect to for creation
        appId = visType.alias.app;
        path = visType.alias.path;
      }
    } else {
      appId = 'visualize';
      path = '#/create?';
    }
    stateTransferService.navigateToEditor(appId, {
      path,
      state: {
        originatingApp: _lib.CANVAS_APP,
        originatingPath: `${pathname}${search}${hash}`
      }
    });
  }, [stateTransferService, pathname, search, hash]);
  const createNewEmbeddableFromFactory = (0, _react.useCallback)(factory => async () => {
    if (_ui_metric.trackCanvasUiMetric) {
      (0, _ui_metric.trackCanvasUiMetric)(_ui_metric.METRIC_TYPE.CLICK, factory.type);
    }
    let embeddableInput;
    if (factory.getExplicitInput) {
      embeddableInput = await factory.getExplicitInput();
    } else {
      const newEmbeddable = await factory.create({});
      embeddableInput = newEmbeddable === null || newEmbeddable === void 0 ? void 0 : newEmbeddable.getInput();
    }
    if (embeddableInput) {
      const expression = (0, _embeddable_input_to_expression.embeddableInputToExpression)(embeddableInput, factory.type, undefined, true);
      addElement({
        expression
      });
    }
  }, [addElement]);
  const createNewEmbeddableFromAction = (0, _react.useCallback)((action, context, closePopover) => event => {
    closePopover();
    if (event.currentTarget instanceof HTMLAnchorElement) {
      if (!event.defaultPrevented &&
      // onClick prevented default
      event.button === 0 && (!event.currentTarget.target || event.currentTarget.target === '_self') && !(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey)) {
        event.preventDefault();
        action.execute(context);
      }
    } else action.execute(context);
  }, []);
  const getVisTypesByGroup = group => visualizationsService.getByGroup(group).sort(({
    name: a
  }, {
    name: b
  }) => {
    if (a < b) {
      return -1;
    }
    if (a > b) {
      return 1;
    }
    return 0;
  }).filter(({
    disableCreate
  }) => !disableCreate);
  const visTypeAliases = visualizationsService.getAliases().sort(({
    promotion: a = false
  }, {
    promotion: b = false
  }) => a === b ? 0 : a ? -1 : 1).filter(({
    disableCreate
  }) => !disableCreate);
  const factories = unwrappedEmbeddableFactories.filter(({
    isEditable,
    factory: {
      type,
      canCreateNew,
      isContainerType
    }
  }) => isEditable && !isContainerType && canCreateNew() && !['visualization', 'ml', 'links'].some(factoryType => {
    return type.includes(factoryType);
  })).map(({
    factory
  }) => factory);
  const promotedVisTypes = getVisTypesByGroup(_public.VisGroups.PROMOTED);
  const legacyVisTypes = getVisTypesByGroup(_public.VisGroups.LEGACY);
  return /*#__PURE__*/_react.default.createElement(_editor_menu.EditorMenu, {
    createNewVisType: createNewVisType,
    createNewEmbeddableFromFactory: createNewEmbeddableFromFactory,
    createNewEmbeddableFromAction: createNewEmbeddableFromAction,
    promotedVisTypes: [].concat(promotedVisTypes, legacyVisTypes),
    factories: factories,
    addPanelActions: addPanelActions,
    visTypeAliases: visTypeAliases
  });
};
exports.EditorMenu = EditorMenu;