"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _add_canvas_element_trigger = require("../../../state/triggers/add_canvas_element_trigger");
var _use_canvas_api = require("../../hooks/use_canvas_api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getEditorMenuButtonLabel: () => _i18n.i18n.translate('xpack.canvas.solutionToolbar.editorMenuButtonLabel', {
    defaultMessage: 'Select type'
  })
};
const EditorMenu = ({
  factories,
  addPanelActions,
  promotedVisTypes,
  visTypeAliases,
  createNewVisType,
  createNewEmbeddableFromAction,
  createNewEmbeddableFromFactory
}) => {
  const factoryGroupMap = {};
  const ungroupedFactories = [];
  const canvasApi = (0, _use_canvas_api.useCanvasApi)();
  let panelCount = 1;

  // Maps factories with a group to create nested context menus for each group type
  // and pushes ungrouped factories into a separate array
  factories.forEach((factory, index) => {
    const {
      grouping
    } = factory;
    if (grouping) {
      grouping.forEach(group => {
        if (factoryGroupMap[group.id]) {
          factoryGroupMap[group.id].factories.push(factory);
        } else {
          factoryGroupMap[group.id] = {
            id: group.id,
            appName: group.getDisplayName ? group.getDisplayName({}) : group.id,
            icon: group.getIconType ? group.getIconType({}) : 'empty',
            factories: [factory],
            panelId: panelCount
          };
          panelCount++;
        }
      });
    } else {
      ungroupedFactories.push(factory);
    }
  });
  const getVisTypeMenuItem = visType => {
    const {
      name,
      title,
      titleInWizard,
      description,
      icon = 'empty'
    } = visType;
    return {
      name: titleInWizard || title,
      icon: icon,
      onClick: createNewVisType(visType),
      'data-test-subj': `visType-${name}`,
      toolTipContent: description
    };
  };
  const getVisTypeAliasMenuItem = visTypeAlias => {
    const {
      name,
      title,
      description,
      icon = 'empty'
    } = visTypeAlias;
    return {
      name: title,
      icon,
      onClick: createNewVisType(visTypeAlias),
      'data-test-subj': `visType-${name}`,
      toolTipContent: description
    };
  };
  const getEmbeddableFactoryMenuItem = factory => {
    const icon = factory !== null && factory !== void 0 && factory.getIconType ? factory.getIconType() : 'empty';
    const toolTipContent = factory !== null && factory !== void 0 && factory.getDescription ? factory.getDescription() : undefined;
    return {
      name: factory.getDisplayName(),
      icon,
      toolTipContent,
      onClick: createNewEmbeddableFromFactory(factory),
      'data-test-subj': `createNew-${factory.type}`
    };
  };
  const getAddPanelActionMenuItems = (0, _react.useCallback)(closePopover => {
    return addPanelActions.map(item => {
      var _item$getDisplayNameT;
      const context = {
        embeddable: canvasApi,
        trigger: _add_canvas_element_trigger.addCanvasElementTrigger
      };
      const actionName = item.getDisplayName(context);
      return {
        name: actionName,
        icon: item.getIconType(context),
        onClick: createNewEmbeddableFromAction(item, context, closePopover),
        'data-test-subj': `create-action-${actionName}`,
        toolTipContent: item === null || item === void 0 ? void 0 : (_item$getDisplayNameT = item.getDisplayNameTooltip) === null || _item$getDisplayNameT === void 0 ? void 0 : _item$getDisplayNameT.call(item, context)
      };
    });
  }, [addPanelActions, createNewEmbeddableFromAction, canvasApi]);
  const getEditorMenuPanels = closePopover => [{
    id: 0,
    items: [...visTypeAliases.map(getVisTypeAliasMenuItem), ...getAddPanelActionMenuItems(closePopover), ...ungroupedFactories.map(getEmbeddableFactoryMenuItem), ...promotedVisTypes.map(getVisTypeMenuItem), ...Object.values(factoryGroupMap).map(({
      id,
      appName,
      icon,
      panelId
    }) => ({
      name: appName,
      icon,
      panel: panelId,
      'data-test-subj': `canvasEditorMenu-${id}Group`
    }))]
  }, ...Object.values(factoryGroupMap).map(({
    appName,
    panelId,
    factories: groupFactories
  }) => ({
    id: panelId,
    title: appName,
    items: groupFactories.map(getEmbeddableFactoryMenuItem)
  }))];
  return /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarPopover, {
    ownFocus: true,
    label: strings.getEditorMenuButtonLabel(),
    panelPaddingSize: "none",
    "data-test-subj": "canvasEditorMenuButton"
  }, ({
    closePopover
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: getEditorMenuPanels(closePopover),
    "data-test-subj": "canvasEditorContextMenu"
  }));
};
exports.EditorMenu = EditorMenu;