"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCanvasApi = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _embeddable_input_to_expression = require("../../../canvas_plugin_src/renderers/embeddable/embeddable_input_to_expression");
var _ui_metric = require("../../lib/ui_metric");
var _elements = require("../../state/actions/elements");
var _workpad = require("../../state/selectors/workpad");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error unconverted file

const useCanvasApi = () => {
  const selectedPageId = (0, _reactRedux.useSelector)(_workpad.getSelectedPage);
  const dispatch = (0, _reactRedux.useDispatch)();
  const createNewEmbeddable = (0, _react.useCallback)((type, embeddableInput) => {
    if (_ui_metric.trackCanvasUiMetric) {
      (0, _ui_metric.trackCanvasUiMetric)(_ui_metric.METRIC_TYPE.CLICK, type);
    }
    if (embeddableInput) {
      const expression = (0, _embeddable_input_to_expression.embeddableInputToExpression)(embeddableInput, type, undefined, true);
      dispatch((0, _elements.addElement)(selectedPageId, {
        expression
      }));
    }
  }, [selectedPageId, dispatch]);
  const getCanvasApi = (0, _react.useCallback)(() => {
    return {
      viewMode: new _rxjs.BehaviorSubject('edit'),
      // always in edit mode
      addNewPanel: async ({
        panelType,
        initialState
      }) => {
        createNewEmbeddable(panelType, initialState);
      },
      disableTriggers: true
      /**
       * getSerializedStateForChild is left out here because we cannot access the state here. That method
       * is injected in `x-pack/plugins/canvas/canvas_plugin_src/renderers/embeddable/embeddable.tsx`
       */
    };
  }, [createNewEmbeddable]);
  return (0, _react.useMemo)(() => getCanvasApi(), [getCanvasApi]);
};
exports.useCanvasApi = useCanvasApi;