"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateWorkpad = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _defaults = require("../../../state/defaults");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

const useCreateWorkpad = () => {
  const workpadService = (0, _services.useWorkpadService)();
  const notifyService = (0, _services.useNotifyService)();
  const history = (0, _reactRouterDom.useHistory)();
  return (0, _react.useCallback)(async _workpad => {
    const workpad = _workpad || (0, _defaults.getDefaultWorkpad)();
    try {
      await workpadService.create(workpad);
      history.push(`/workpad/${workpad.id}/page/1`);
    } catch (err) {
      notifyService.error(err, {
        title: errors.getCreateFailureErrorMessage()
      });
    }
    return;
  }, [notifyService, history, workpadService]);
};
exports.useCreateWorkpad = useCreateWorkpad;
const errors = {
  getCreateFailureErrorMessage: () => _i18n.i18n.translate('xpack.canvas.error.useCreateWorkpad.createFailureErrorMessage', {
    defaultMessage: `Couldn't create workpad`
  })
};