"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateFromTemplate = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateFromTemplate = () => {
  const workpadService = (0, _services.useWorkpadService)();
  const notifyService = (0, _services.useNotifyService)();
  const history = (0, _reactRouterDom.useHistory)();
  return (0, _react.useCallback)(async template => {
    try {
      const result = await workpadService.createFromTemplate(template.id);
      history.push(`/workpad/${result.id}/page/1`);
    } catch (e) {
      notifyService.error(e, {
        title: `Couldn't create workpad from template`
      });
    }
  }, [workpadService, notifyService, history]);
};
exports.useCreateFromTemplate = useCreateFromTemplate;