"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESFieldSelect = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _es_field_select = require("./es_field_select");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESFieldSelect = props => {
  const {
    index,
    value,
    onChange
  } = props;
  const [fields, setFields] = (0, _react.useState)([]);
  const loadingFields = (0, _react.useRef)(false);
  const {
    getFields
  } = (0, _services.useDataViewsService)();
  (0, _react.useEffect)(() => {
    loadingFields.current = true;
    getFields(index).then(newFields => setFields(newFields || [])).finally(() => {
      loadingFields.current = false;
    });
  }, [index, getFields]);
  (0, _react.useEffect)(() => {
    if (!loadingFields.current && value && !fields.includes(value)) {
      onChange(null);
    }
  }, [value, fields, onChange]);
  return /*#__PURE__*/_react.default.createElement(_es_field_select.ESFieldSelect, (0, _extends2.default)({}, props, {
    fields: fields
  }));
};
exports.ESFieldSelect = ESFieldSelect;