"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _shortcut_manager = require("../../lib/shortcut_manager");
var _routes = require("../../routes");
var _flyouts = require("../flyouts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

class ShortcutManagerContextWrapper extends _react.default.Component {
  getChildContext() {
    return {
      shortcuts: _shortcut_manager.shortcutManager
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.props.children);
  }
}
(0, _defineProperty2.default)(ShortcutManagerContextWrapper, "childContextTypes", {
  shortcuts: _propTypes.default.object.isRequired
});
const App = ({
  history
}) => {
  const {
    updatePath
  } = (0, _services.useNavLinkService)();
  (0, _react.useEffect)(() => {
    return history.listen(({
      pathname,
      search
    }) => {
      updatePath(pathname + search);
    });
  });
  return /*#__PURE__*/_react.default.createElement(ShortcutManagerContextWrapper, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvas canvasContainer"
  }, /*#__PURE__*/_react.default.createElement(_routes.CanvasRouter, {
    history: history
  }), /*#__PURE__*/_react.default.createElement(_flyouts.Flyouts, null)));
};
exports.App = App;