"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.embeddableRendererFactory = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _lodash = require("lodash");
var _services = require("../../../public/services");
var _lib = require("../../../common/lib");
var _i18n = require("../../../i18n");
var _embeddable_input_to_expression = require("./embeddable_input_to_expression");
var _use_get_app_context = require("./use_get_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  embeddable: strings
} = _i18n.RendererStrings;

// registry of references to embeddables on the workpad
const embeddablesRegistry = {};
const renderReactEmbeddable = ({
  type,
  uuid,
  input,
  container,
  handlers,
  core
}) => {
  // wrap in functional component to allow usage of hooks
  const RendererWrapper = () => {
    const getAppContext = (0, _use_get_app_context.useGetAppContext)(core);
    const searchApi = (0, _presentationPublishing.useSearchApi)({
      filters: input.filters
    });
    return /*#__PURE__*/_react.default.createElement(_public.ReactEmbeddableRenderer, {
      type: type,
      maybeId: uuid,
      getParentApi: () => ({
        ...container,
        getAppContext,
        getSerializedStateForChild: () => ({
          rawState: (0, _lodash.omit)(input, ['disableTriggers', 'filters'])
        }),
        ...searchApi
      }),
      key: `${type}_${uuid}`,
      onAnyStateChange: newState => {
        const newExpression = (0, _embeddable_input_to_expression.embeddableInputToExpression)(newState.rawState, type, undefined, true);
        if (newExpression) handlers.onEmbeddableInputChange(newExpression);
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement("div", {
    className: _lib.CANVAS_EMBEDDABLE_CLASSNAME,
    style: {
      width: '100%',
      height: '100%',
      cursor: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(RendererWrapper, null)));
};
const renderEmbeddableFactory = (core, _plugins) => {
  const EmbeddableRenderer = ({
    embeddable
  }) => {
    const getAppContext = (0, _use_get_app_context.useGetAppContext)(core);
    embeddable.getAppContext = getAppContext;
    return /*#__PURE__*/_react.default.createElement(_public.EmbeddablePanel, {
      embeddable: embeddable
    });
  };
  return embeddableObject => {
    return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement("div", {
      className: _lib.CANVAS_EMBEDDABLE_CLASSNAME,
      style: {
        width: '100%',
        height: '100%',
        cursor: 'auto'
      }
    }, /*#__PURE__*/_react.default.createElement(EmbeddableRenderer, {
      embeddable: embeddableObject
    })));
  };
};
const embeddableRendererFactory = (core, plugins) => {
  const renderEmbeddable = renderEmbeddableFactory(core, plugins);
  return () => ({
    name: 'embeddable',
    displayName: strings.getDisplayName(),
    help: strings.getHelpDescription(),
    reuseDomNode: true,
    render: async (domNode, {
      input,
      embeddableType,
      canvasApi
    }, handlers) => {
      const {
        embeddables
      } = _services.pluginServices.getServices();
      const uniqueId = handlers.getElementId();
      const isByValueEnabled = plugins.presentationUtil.labsService.isProjectEnabled('labs:canvas:byValueEmbeddable');
      if (embeddables.reactEmbeddableRegistryHasKey(embeddableType)) {
        /**
         * Prioritize React embeddables
         */
        _reactDom.default.render(renderReactEmbeddable({
          input,
          handlers,
          uuid: uniqueId,
          type: embeddableType,
          container: canvasApi,
          core
        }), domNode, () => handlers.done());
        handlers.onDestroy(() => {
          handlers.onEmbeddableDestroyed();
          return _reactDom.default.unmountComponentAtNode(domNode);
        });
      } else if (!embeddablesRegistry[uniqueId]) {
        /**
         * Handle legacy embeddables - embeddable does not exist in registry
         */
        const factory = Array.from(plugins.embeddable.getEmbeddableFactories()).find(embeddableFactory => embeddableFactory.type === embeddableType);
        if (!factory) {
          handlers.done();
          throw new _public.EmbeddableFactoryNotFoundError(embeddableType);
        }
        const embeddableInput = {
          ...input,
          id: uniqueId,
          executionContext: {
            type: 'canvas'
          }
        };
        const embeddablePromise = input.savedObjectId ? factory.createFromSavedObject(input.savedObjectId, embeddableInput).then(embeddable => {
          // stores embeddable in registrey
          embeddablesRegistry[uniqueId] = embeddable;
          return embeddable;
        }) : factory.create(embeddableInput).then(embeddable => {
          if (!embeddable || (0, _public.isErrorEmbeddable)(embeddable)) {
            return;
          }
          // stores embeddable in registry
          embeddablesRegistry[uniqueId] = embeddable;
          return embeddable;
        });
        embeddablesRegistry[uniqueId] = embeddablePromise;
        const embeddableObject = await (async () => embeddablePromise)();
        const palettes = await plugins.charts.palettes.getPalettes();
        embeddablesRegistry[uniqueId] = embeddableObject;
        _reactDom.default.unmountComponentAtNode(domNode);
        const subscription = embeddableObject.getInput$().subscribe(function (updatedInput) {
          const updatedExpression = (0, _embeddable_input_to_expression.embeddableInputToExpression)(updatedInput, embeddableType, palettes, isByValueEnabled);
          if (updatedExpression) {
            handlers.onEmbeddableInputChange(updatedExpression);
          }
        });
        _reactDom.default.render(renderEmbeddable(embeddableObject), domNode, () => handlers.done());
        handlers.onDestroy(() => {
          subscription.unsubscribe();
          handlers.onEmbeddableDestroyed();
          delete embeddablesRegistry[uniqueId];
          return _reactDom.default.unmountComponentAtNode(domNode);
        });
      } else {
        /**
         * Handle legacy embeddables - embeddable already exists in registry
         */
        const embeddable = embeddablesRegistry[uniqueId];

        // updating embeddable input with changes made to expression or filters
        if ('updateInput' in embeddable) {
          embeddable.updateInput(input);
          embeddable.reload();
        }
      }
    }
  });
};
exports.embeddableRendererFactory = embeddableRendererFactory;